/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.Countable;
import de.caff.generics.Types;
import de.caff.generics.function.Procedure1;
import de.caff.generics.function.Procedure2;
import de.caff.generics.mda.MultiDimensionalReadAccess;
import de.caff.generics.mda.OneDimensionalReadAccess;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;

public interface TwoDimensionalReadAccess<T>
extends MultiDimensionalReadAccess<T> {
    public static final TwoDimensionalReadAccess<?> EMPTY = new TwoDimensionalReadAccess<Object>(){

        @Override
        public int sizeX() {
            return 0;
        }

        @Override
        public int sizeY() {
            return 0;
        }

        @Override
        public Object getElementAt(int n, int n2) {
            throw new IndexOutOfBoundsException();
        }
    };

    public int sizeX();

    public int sizeY();

    public T getElementAt(int var1, int var2);

    @Override
    default public T getElement(int ... nArray) {
        if (nArray.length != 2) {
            throw new IllegalArgumentException("Need 2 index for 2-dimensional array!");
        }
        return this.getElementAt(nArray[0], nArray[1]);
    }

    @NotNull
    default public OneDimensionalReadAccess<T> subAtX(final int n) {
        return new OneDimensionalReadAccess<T>(){

            @Override
            public int size() {
                return TwoDimensionalReadAccess.this.sizeY();
            }

            @Override
            public T get(int n2) {
                return TwoDimensionalReadAccess.this.getElementAt(n, n2);
            }
        };
    }

    @NotNull
    default public Iterator<OneDimensionalReadAccess<T>> xIterator() {
        return new Iterator<OneDimensionalReadAccess<T>>(){
            private int x = 0;

            @Override
            public boolean hasNext() {
                return this.x < TwoDimensionalReadAccess.this.sizeX();
            }

            @Override
            public OneDimensionalReadAccess<T> next() {
                if (this.x >= TwoDimensionalReadAccess.this.sizeX()) {
                    throw new NoSuchElementException();
                }
                return TwoDimensionalReadAccess.this.subAtX(this.x++);
            }
        };
    }

    @NotNull
    default public Iterable<OneDimensionalReadAccess<T>> xIterable() {
        return this::xIterator;
    }

    @NotNull
    default public Iterator<OneDimensionalReadAccess<T>> yIterator() {
        return new Iterator<OneDimensionalReadAccess<T>>(){
            private int y = 0;

            @Override
            public boolean hasNext() {
                return this.y < TwoDimensionalReadAccess.this.sizeY();
            }

            @Override
            public OneDimensionalReadAccess<T> next() {
                if (this.y >= TwoDimensionalReadAccess.this.sizeY()) {
                    throw new NoSuchElementException();
                }
                return TwoDimensionalReadAccess.this.subAtY(this.y++);
            }
        };
    }

    @NotNull
    default public Iterable<OneDimensionalReadAccess<T>> yIterable() {
        return this::yIterator;
    }

    @NotNull
    default public OneDimensionalReadAccess<T> subAtY(final int n) {
        return new OneDimensionalReadAccess<T>(){

            @Override
            public int size() {
                return TwoDimensionalReadAccess.this.sizeX();
            }

            @Override
            public T get(int n2) {
                return TwoDimensionalReadAccess.this.getElementAt(n2, n);
            }
        };
    }

    @NotNull
    default public TwoDimensionalReadAccess<T> transposed() {
        return new TwoDimensionalReadAccess<T>(){

            @Override
            public int sizeX() {
                return TwoDimensionalReadAccess.this.sizeY();
            }

            @Override
            public int sizeY() {
                return TwoDimensionalReadAccess.this.sizeX();
            }

            @Override
            public T getElementAt(int n, int n2) {
                return TwoDimensionalReadAccess.this.getElementAt(n2, n);
            }

            @Override
            @NotNull
            public TwoDimensionalReadAccess<T> transposed() {
                return TwoDimensionalReadAccess.this;
            }
        };
    }

    @Override
    default public int getNumDimensions() {
        return 2;
    }

    @Override
    default public int getSize(int n) {
        switch (n) {
            case 0: {
                return this.sizeX();
            }
            case 1: {
                return this.sizeY();
            }
        }
        throw new IllegalArgumentException("There are only 2 dimensions!");
    }

    @Override
    @NotNull
    default public int[] getSizes() {
        return new int[]{this.sizeX(), this.sizeY()};
    }

    @Override
    default public long getNumElements() {
        return (long)this.sizeX() * (long)this.sizeY();
    }

    @NotNull
    default public <TOUT> TwoDimensionalReadAccess<TOUT> view(final @NotNull Function<T, TOUT> function) {
        return new TwoDimensionalReadAccess<TOUT>(){

            @Override
            public int sizeX() {
                return TwoDimensionalReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return TwoDimensionalReadAccess.this.sizeY();
            }

            @Override
            public TOUT getElementAt(int n, int n2) {
                return function.apply(TwoDimensionalReadAccess.this.getElementAt(n, n2));
            }
        };
    }

    @Override
    default public void visitAll(@NotNull Procedure2<? super T, int[]> procedure2) {
        int n = this.sizeX();
        int n2 = this.sizeY();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                procedure2.apply(this.getElementAt(i, j), new int[]{i, j});
            }
        }
    }

    @Override
    default public void visitAll(@NotNull Procedure1<? super T> procedure1) {
        int n = this.sizeX();
        int n2 = this.sizeY();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                procedure1.apply(this.getElementAt(i, j));
            }
        }
    }

    @NotNull
    default public Base<T> asBase() {
        return new Base<T>(){

            @Override
            public int sizeX() {
                return TwoDimensionalReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return TwoDimensionalReadAccess.this.sizeY();
            }

            @Override
            public T getElementAt(int n, int n2) {
                return TwoDimensionalReadAccess.this.getElementAt(n, n2);
            }
        };
    }

    @NotNull
    public static String toString(@NotNull TwoDimensionalReadAccess<?> twoDimensionalReadAccess) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = twoDimensionalReadAccess.sizeX();
        int n2 = twoDimensionalReadAccess.sizeY();
        stringBuilder.append("[");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(i == 0 ? "[" : ", [");
            for (int j = 0; j < n2; ++j) {
                if (j > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(twoDimensionalReadAccess.getElementAt(i, j));
            }
            stringBuilder.append("]");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static <E> boolean equal(@NotNull TwoDimensionalReadAccess<? extends E> twoDimensionalReadAccess, @NotNull TwoDimensionalReadAccess<? extends E> twoDimensionalReadAccess2, @NotNull BiPredicate<E, E> biPredicate) {
        if (twoDimensionalReadAccess == twoDimensionalReadAccess2) {
            return true;
        }
        if (twoDimensionalReadAccess.sizeX() != twoDimensionalReadAccess2.sizeX() || twoDimensionalReadAccess.sizeY() != twoDimensionalReadAccess2.sizeY()) {
            return false;
        }
        Iterator<OneDimensionalReadAccess<E>> iterator = twoDimensionalReadAccess.xIterator();
        Iterator<OneDimensionalReadAccess<E>> iterator2 = twoDimensionalReadAccess2.xIterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (Countable.equal((Countable)iterator.next(), (Countable)iterator2.next(), biPredicate)) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    public static int hash(@NotNull TwoDimensionalReadAccess<?> twoDimensionalReadAccess) {
        int n = 1;
        for (OneDimensionalReadAccess<?> oneDimensionalReadAccess : twoDimensionalReadAccess.xIterable()) {
            n = 31 * n + Types.hash(oneDimensionalReadAccess);
        }
        return n;
    }

    @NotNull
    public static <E> TwoDimensionalReadAccess<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> TwoDimensionalReadAccess<E> singleton(final E e) {
        return new Base<E>(){

            @Override
            public int sizeX() {
                return 1;
            }

            @Override
            public int sizeY() {
                return 1;
            }

            @Override
            public E getElementAt(int n, int n2) {
                if (n != 0 || n2 != 0) {
                    throw new IndexOutOfBoundsException();
                }
                return e;
            }
        };
    }

    public static abstract class Base<TT>
    implements TwoDimensionalReadAccess<TT> {
        public String toString() {
            return TwoDimensionalReadAccess.toString(this);
        }

        public boolean equals(Object object) {
            if (!(object instanceof TwoDimensionalReadAccess)) {
                return false;
            }
            return TwoDimensionalReadAccess.equal(this, (TwoDimensionalReadAccess)object, Objects::deepEquals);
        }

        public int hashCode() {
            return TwoDimensionalReadAccess.hash(this);
        }

        @Override
        @NotNull
        public Base<TT> asBase() {
            return this;
        }
    }
}

