/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.mda.TwoDimensionalLongAccess;
import de.caff.generics.mda.TwoDimensionalLongReadAccess;

public class TwoDimensionalLongArray
extends TwoDimensionalLongReadAccess.Base
implements TwoDimensionalLongAccess {
    @NotNull
    private final long[][] values;

    public TwoDimensionalLongArray(int n, int n2) {
        this.values = new long[n][n2];
    }

    public TwoDimensionalLongArray(int n, long ... lArray) {
        if (n <= 0 || lArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (lArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = new long[lArray.length / n][n];
        for (int i = 0; i < lArray.length; ++i) {
            this.values[i / n][i % n] = lArray[i];
        }
    }

    @Override
    public void setValueAt(long l, int n, int n2) {
        this.values[n][n2] = l;
    }

    @Override
    public long getValueAt(int n, int n2) {
        return this.values[n][n2];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }
}

