/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.mda.TwoDimensionalIntAccess;
import de.caff.generics.mda.TwoDimensionalIntReadAccess;
import java.util.function.IntBinaryOperator;

public class TwoDimensionalIntArray
extends TwoDimensionalIntReadAccess.Base
implements TwoDimensionalIntAccess {
    @NotNull
    private final int[][] values;

    public TwoDimensionalIntArray(int n, int n2) {
        this.values = new int[n][n2];
    }

    public TwoDimensionalIntArray(int n, int n2, @NotNull IntBinaryOperator intBinaryOperator) {
        this(n, n2);
        this.fillValuesByIndex(intBinaryOperator);
    }

    public TwoDimensionalIntArray(int n, int ... nArray) {
        if (n <= 0 || nArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (nArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = new int[nArray.length / n][n];
        for (int i = 0; i < nArray.length; ++i) {
            this.values[i / n][i % n] = nArray[i];
        }
    }

    @Override
    public void setValueAt(int n, int n2, int n3) {
        this.values[n2][n3] = n;
    }

    @Override
    public int getValueAt(int n, int n2) {
        return this.values[n][n2];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }
}

