/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToFloatFunction2;
import de.caff.generics.mda.TwoDimensionalFloatAccess;
import de.caff.generics.mda.TwoDimensionalFloatReadAccess;

public class TwoDimensionalFloatArray
extends TwoDimensionalFloatReadAccess.Base
implements TwoDimensionalFloatAccess {
    @NotNull
    private final float[][] values;

    public TwoDimensionalFloatArray(int n, int n2) {
        this.values = new float[n][n2];
    }

    public TwoDimensionalFloatArray(int n, int n2, @NotNull IntToFloatFunction2 intToFloatFunction2) {
        this(n, n2);
        this.fillValuesByIndex(intToFloatFunction2);
    }

    public TwoDimensionalFloatArray(int n, float ... fArray) {
        if (n <= 0 || fArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (fArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = new float[fArray.length / n][n];
        for (int i = 0; i < fArray.length; ++i) {
            this.values[i / n][i % n] = fArray[i];
        }
    }

    @Override
    public void setValueAt(float f, int n, int n2) {
        this.values[n][n2] = f;
    }

    @Override
    public float getValueAt(int n, int n2) {
        return this.values[n][n2];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }
}

