/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToDoubleFunction2;
import de.caff.generics.mda.TwoDimensionalDoubleAccess;
import de.caff.generics.mda.TwoDimensionalDoubleReadAccess;

public class TwoDimensionalDoubleArray
extends TwoDimensionalDoubleReadAccess.Base
implements TwoDimensionalDoubleAccess {
    @NotNull
    private final double[][] values;

    public TwoDimensionalDoubleArray(int n, int n2) {
        this.values = new double[n][n2];
    }

    public TwoDimensionalDoubleArray(int n, int n2, @NotNull IntToDoubleFunction2 intToDoubleFunction2) {
        this(n, n2);
        this.fillValuesByIndex(intToDoubleFunction2);
    }

    public TwoDimensionalDoubleArray(int n, double ... dArray) {
        if (n <= 0 || dArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (dArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = new double[dArray.length / n][n];
        for (int i = 0; i < dArray.length; ++i) {
            this.values[i / n][i % n] = dArray[i];
        }
    }

    public TwoDimensionalDoubleArray(@NotNull TwoDimensionalDoubleReadAccess twoDimensionalDoubleReadAccess) {
        this(twoDimensionalDoubleReadAccess.sizeX(), twoDimensionalDoubleReadAccess.sizeY(), twoDimensionalDoubleReadAccess::getValueAt);
    }

    private TwoDimensionalDoubleArray(@NotNull TwoDimensionalDoubleArray twoDimensionalDoubleArray) {
        this.values = new double[twoDimensionalDoubleArray.values.length][];
        for (int i = this.values.length - 1; i >= 0; --i) {
            this.values[i] = (double[])twoDimensionalDoubleArray.values[i].clone();
        }
    }

    @Override
    public void setValueAt(double d, int n, int n2) {
        this.values[n][n2] = d;
    }

    @Override
    public double getValueAt(int n, int n2) {
        return this.values[n][n2];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }

    public void invertX() {
        int n = this.sizeX();
        for (int i = 0; i < n / 2; ++i) {
            double[] dArray = this.values[i];
            this.values[i] = this.values[n - i - 1];
            this.values[n - i - 1] = dArray;
        }
    }

    public void invertY() {
        int n = this.sizeY();
        for (double[] dArray : this.values) {
            for (int i = 0; i < n / 2; ++i) {
                double d = dArray[i];
                dArray[i] = dArray[n - i - 1];
                dArray[n - i - 1] = d;
            }
        }
    }

    @NotNull
    public TwoDimensionalDoubleArray copy() {
        return new TwoDimensionalDoubleArray(this);
    }

    @NotNull
    public static TwoDimensionalDoubleArray unitySquare(int n) {
        TwoDimensionalDoubleArray twoDimensionalDoubleArray = new TwoDimensionalDoubleArray(n, n);
        for (int i = 0; i < n; ++i) {
            twoDimensionalDoubleArray.setValueAt(1.0, i, i);
        }
        return twoDimensionalDoubleArray;
    }
}

