/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToCharFunction2;
import de.caff.generics.mda.TwoDimensionalCharAccess;

public class TwoDimensionalCharArray
implements TwoDimensionalCharAccess {
    @NotNull
    private final char[][] values;

    public TwoDimensionalCharArray(int n, int n2) {
        this.values = new char[n][n2];
    }

    public TwoDimensionalCharArray(int n, int n2, @NotNull IntToCharFunction2 intToCharFunction2) {
        this(n, n2);
        this.fillValuesByIndex(intToCharFunction2);
    }

    public TwoDimensionalCharArray(int n, char ... cArray) {
        if (n <= 0 || cArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (cArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = new char[cArray.length / n][n];
        for (int i = 0; i < cArray.length; ++i) {
            this.values[i / n][i % n] = cArray[i];
        }
    }

    @Override
    public void setValueAt(char c, int n, int n2) {
        this.values[n][n2] = c;
    }

    @Override
    public char getValueAt(int n, int n2) {
        return this.values[n][n2];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }
}

