/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToByteFunction2;
import de.caff.generics.mda.TwoDimensionalByteAccess;
import de.caff.generics.mda.TwoDimensionalByteReadAccess;

public class TwoDimensionalByteArray
extends TwoDimensionalByteReadAccess.Base
implements TwoDimensionalByteAccess {
    @NotNull
    private final byte[][] values;

    public TwoDimensionalByteArray(int n, int n2) {
        this.values = new byte[n][n2];
    }

    public TwoDimensionalByteArray(int n, int n2, @NotNull IntToByteFunction2 intToByteFunction2) {
        this(n, n2);
        this.fillValuesByIndex(intToByteFunction2);
    }

    public TwoDimensionalByteArray(int n, byte ... byArray) {
        if (n <= 0 || byArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (byArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = new byte[byArray.length / n][n];
        for (int i = 0; i < byArray.length; ++i) {
            this.values[i / n][i % n] = byArray[i];
        }
    }

    @Override
    public void setValueAt(byte by, int n, int n2) {
        this.values[n][n2] = by;
    }

    @Override
    public byte getValueAt(int n, int n2) {
        return this.values[n][n2];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }
}

