/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntPredicate2;
import de.caff.generics.mda.TwoDimensionalBooleanAccess;
import de.caff.generics.mda.TwoDimensionalBooleanReadAccess;

public class TwoDimensionalBooleanArray
extends TwoDimensionalBooleanReadAccess.Base
implements TwoDimensionalBooleanAccess {
    @NotNull
    private final boolean[][] values;

    public TwoDimensionalBooleanArray(int n, int n2) {
        this.values = new boolean[n][n2];
    }

    public TwoDimensionalBooleanArray(int n, int n2, @NotNull IntPredicate2 intPredicate2) {
        this(n, n2);
        this.fillValuesByIndex(intPredicate2);
    }

    public TwoDimensionalBooleanArray(int n, boolean ... blArray) {
        if (n <= 0 || blArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (blArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = new boolean[blArray.length / n][n];
        for (int i = 0; i < blArray.length; ++i) {
            this.values[i / n][i % n] = blArray[i];
        }
    }

    @Override
    public void setValueAt(boolean bl, int n, int n2) {
        this.values[n][n2] = bl;
    }

    @Override
    public boolean getValueAt(int n, int n2) {
        return this.values[n][n2];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }
}

