/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Indexable;
import de.caff.generics.Types;
import de.caff.generics.function.IntFunction2;
import de.caff.generics.mda.TwoDimensionalAccess;
import de.caff.generics.mda.TwoDimensionalReadAccess;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

public class TwoDimensionalArray<T>
extends TwoDimensionalReadAccess.Base<T>
implements TwoDimensionalAccess<T> {
    @NotNull
    private final Object[][] elements;

    public TwoDimensionalArray(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        this.elements = new Object[n][n2];
    }

    public TwoDimensionalArray(int n, int n2, @NotNull IntFunction2<? extends T> intFunction2) {
        this(n, n2);
        this.fillByIndex(intFunction2);
    }

    public TwoDimensionalArray(@NotNull Supplier<? extends T> supplier, int n, int n2) {
        this(n, n2);
        for (Object[] objectArray : this.elements) {
            Types.fillArray(objectArray, supplier);
        }
    }

    @SafeVarargs
    public TwoDimensionalArray(int n, T ... TArray) {
        this(n, (Collection<T>)Arrays.asList(TArray));
    }

    private static int getXSize(int n, int n2) {
        if (n2 % n != 0) {
            throw new IllegalArgumentException("Size of incoming elements has to be a multiple of Y size!");
        }
        return n2 / n;
    }

    public TwoDimensionalArray(int n, @NotNull Collection<T> collection) {
        this(TwoDimensionalArray.getXSize(n, collection.size()), n, (Iterable<T>)collection);
    }

    public TwoDimensionalArray(int n, @NotNull Indexable<T> indexable) {
        this(TwoDimensionalArray.getXSize(n, indexable.size()), n, indexable);
    }

    public TwoDimensionalArray(int n, int n2, @NotNull Iterable<T> iterable) {
        this(n, n2);
        int n3 = n * n2;
        int n4 = 0;
        for (T t : iterable) {
            if (n4 == n3) {
                return;
            }
            this.setElementAt(t, n4 / n2, n4 % n2);
            ++n4;
        }
        if (n4 < n3) {
            throw new IllegalArgumentException("Not enough elements in points to fill the ");
        }
    }

    public TwoDimensionalArray(@NotNull TwoDimensionalReadAccess<T> twoDimensionalReadAccess) {
        this.elements = new Object[twoDimensionalReadAccess.sizeX()][twoDimensionalReadAccess.sizeY()];
        for (int i = twoDimensionalReadAccess.sizeX() - 1; i >= 0; --i) {
            Object[] objectArray = this.elements[i];
            for (int j = twoDimensionalReadAccess.sizeY() - 1; j >= 0; --j) {
                objectArray[j] = twoDimensionalReadAccess.getElementAt(i, j);
            }
        }
    }

    @Override
    public void setElementAt(T t, int n, int n2) {
        this.elements[n][n2] = t;
    }

    @Override
    public int sizeX() {
        return this.elements.length;
    }

    @Override
    public int sizeY() {
        return this.elements[0].length;
    }

    @Override
    public T getElementAt(int n, int n2) {
        return (T)this.elements[n][n2];
    }

    @NotNull
    public <R> TwoDimensionalArray<R> getCopy(@NotNull Function<? super T, ? extends R> function) {
        return this.resized(this.sizeX(), this.sizeY(), function, null);
    }

    @NotNull
    public TwoDimensionalArray<T> resized(int n, int n2) {
        return this.resized(n, n2, object -> object, null);
    }

    @NotNull
    public TwoDimensionalArray<T> resized(int n, int n2, @Nullable IntFunction2<? extends T> intFunction2) {
        return this.resized(n, n2, object -> object, intFunction2);
    }

    @NotNull
    public <R> TwoDimensionalArray<R> resized(int n, int n2, @NotNull Function<? super T, ? extends R> function, @Nullable IntFunction2<? extends R> intFunction2) {
        int n5 = this.sizeX();
        int n6 = this.sizeY();
        TwoDimensionalArray<Object> twoDimensionalArray = new TwoDimensionalArray<Object>(n, n2);
        twoDimensionalArray.fillByIndex((n3, n4) -> n3 < n5 && n4 < n6 ? function.apply((T)this.getElementAt(n3, n4)) : (intFunction2 != null ? intFunction2.applyAsInt(n3, n4) : null));
        return twoDimensionalArray;
    }
}

