/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Indexable;
import de.caff.generics.function.IntFunction2;
import de.caff.generics.function.Procedure1;
import de.caff.generics.function.Procedure2;
import de.caff.generics.mda.MultiDimensionalAccess;
import de.caff.generics.mda.MultiIndexLinearizer;
import de.caff.generics.mda.OneDimensionalAccess;
import de.caff.generics.mda.TwoDimensionalArray;
import de.caff.generics.mda.TwoDimensionalReadAccess;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public interface TwoDimensionalAccess<T>
extends TwoDimensionalReadAccess<T>,
MultiDimensionalAccess<T> {
    public static final TwoDimensionalAccess<Object> EMPTY = new TwoDimensionalAccess<Object>(){

        @Override
        public void setElementAt(Object object, int n, int n2) {
            throw new IndexOutOfBoundsException("Cannot set elements of empty 2dimensional array!");
        }

        @Override
        public int sizeX() {
            return 0;
        }

        @Override
        public int sizeY() {
            return 0;
        }

        @Override
        public Object getElementAt(int n, int n2) {
            throw new IndexOutOfBoundsException("Cannot get elements from empty 2dimensional array!");
        }

        @Override
        public void setElement(Object object, int ... nArray) {
            throw new IndexOutOfBoundsException("Cannot get elements from empty 2dimensional array!");
        }

        @Override
        @NotNull
        public OneDimensionalAccess<Object> subAtX(int n) {
            throw new IndexOutOfBoundsException("Cannot get sub array from empty 2dimensional array!");
        }

        @Override
        @NotNull
        public OneDimensionalAccess<Object> subAtY(int n) {
            throw new IndexOutOfBoundsException("Cannot get sub array from empty 2dimensional array!");
        }

        @Override
        @NotNull
        public TwoDimensionalAccess<Object> transposed() {
            return this;
        }

        @Override
        public void changeAll(@NotNull BiFunction<? super Object, int[], ?> biFunction) {
        }

        @Override
        public void changeAll(@NotNull Function<? super Object, ?> function) {
        }

        @Override
        public Object change(@NotNull Function<? super Object, ?> function, int ... nArray) {
            throw new IndexOutOfBoundsException("Cannot change elements of empty 2dimensional array!");
        }

        @Override
        public void setFrom(@NotNull MultiIndexLinearizer.Sequencer sequencer, @NotNull Collection<?> collection) {
            if (!collection.isEmpty()) {
                throw new IndexOutOfBoundsException("Cannot set elemeets of empty 2dimensional array!");
            }
        }

        @Override
        public void setFrom(@NotNull MultiIndexLinearizer.Sequencer sequencer, @NotNull Indexable<?> indexable) {
            if (!indexable.isEmpty()) {
                throw new IndexOutOfBoundsException("Cannot set elemeets of empty 2dimensional array!");
            }
        }

        @Override
        public void setFrom(@NotNull MultiIndexLinearizer.Sequencer sequencer, @NotNull Iterable<?> iterable) {
            if (iterable.iterator().hasNext()) {
                throw new IndexOutOfBoundsException("Cannot set elemeets of empty 2dimensional array!");
            }
        }

        @Override
        public MultiDimensionalAccess<Object> setAll(@NotNull Function<int[], ?> function) {
            return this;
        }

        @Override
        public Object getElement(int ... nArray) {
            throw new IndexOutOfBoundsException("Cannot get elements from empty 2dimensional array!");
        }

        @Override
        public int getNumDimensions() {
            return 2;
        }

        @Override
        public int getSize(int n) {
            return 0;
        }

        @Override
        @NotNull
        public int[] getSizes() {
            return new int[]{0, 0};
        }

        @Override
        public long getNumElements() {
            return 0L;
        }

        @Override
        @NotNull
        public <TOUT> TwoDimensionalReadAccess<TOUT> view(@NotNull Function<Object, TOUT> function) {
            return TwoDimensionalAccess.empty();
        }

        @Override
        public void visitAll(@NotNull Procedure2<? super Object, int[]> procedure2) {
        }

        @Override
        public void visitAll(@NotNull Procedure1<? super Object> procedure1) {
        }
    };

    public void setElementAt(T var1, int var2, int var3);

    @Override
    default public void setElement(T t, int ... nArray) {
        if (nArray.length != 2) {
            throw new IllegalArgumentException("Need 2 indexes for 2-dimensional access!");
        }
        this.setElementAt(t, nArray[0], nArray[1]);
    }

    @Override
    @NotNull
    default public OneDimensionalAccess<T> subAtX(final int n) {
        return new OneDimensionalAccess<T>(){

            @Override
            public void set(int n2, T t) {
                TwoDimensionalAccess.this.setElementAt(t, n, n2);
            }

            @Override
            public int size() {
                return TwoDimensionalAccess.this.sizeY();
            }

            @Override
            public T get(int n2) {
                return TwoDimensionalAccess.this.getElementAt(n, n2);
            }
        };
    }

    @Override
    @NotNull
    default public OneDimensionalAccess<T> subAtY(final int n) {
        return new OneDimensionalAccess<T>(){

            @Override
            public void set(int n2, T t) {
                TwoDimensionalAccess.this.setElementAt(t, n2, n);
            }

            @Override
            public int size() {
                return TwoDimensionalAccess.this.sizeX();
            }

            @Override
            public T get(int n2) {
                return TwoDimensionalAccess.this.getElementAt(n2, n);
            }
        };
    }

    @Override
    @NotNull
    default public TwoDimensionalAccess<T> transposed() {
        return new TwoDimensionalAccess<T>(){

            @Override
            public void setElementAt(T t, int n, int n2) {
                TwoDimensionalAccess.this.setElementAt(t, n2, n);
            }

            @Override
            public int sizeX() {
                return TwoDimensionalAccess.this.sizeY();
            }

            @Override
            public int sizeY() {
                return TwoDimensionalAccess.this.sizeX();
            }

            @Override
            public T getElementAt(int n, int n2) {
                return TwoDimensionalAccess.this.getElementAt(n2, n);
            }
        };
    }

    @Override
    default public void changeAll(@NotNull BiFunction<? super T, int[], ? extends T> biFunction) {
        int n = this.sizeX();
        int n2 = this.sizeY();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.setElementAt(biFunction.apply(this.getElementAt(i, j), new int[]{i, j}), i, j);
            }
        }
    }

    @Override
    default public void changeAll(@NotNull Function<? super T, ? extends T> function) {
        int n = this.sizeX();
        int n2 = this.sizeY();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.setElementAt(function.apply(this.getElementAt(i, j)), i, j);
            }
        }
    }

    default public void fillByIndex(@NotNull IntFunction2<? extends T> intFunction2) {
        int n = this.sizeX();
        int n2 = this.sizeY();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.setElementAt(intFunction2.applyAsInt(i, j), i, j);
            }
        }
    }

    @NotNull
    public static <E> TwoDimensionalAccess<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> TwoDimensionalAccess<E> zeroX(final int n) {
        if (n == 0) {
            return TwoDimensionalAccess.empty();
        }
        if (n < 0) {
            throw new IllegalArgumentException("numY has to be non-negative!");
        }
        return new TwoDimensionalAccess<E>(){

            @Override
            public void setElementAt(E e, int n3, int n2) {
                throw new IndexOutOfBoundsException("No setting for access with no X size!");
            }

            @Override
            public int sizeX() {
                return 0;
            }

            @Override
            public int sizeY() {
                return n;
            }

            @Override
            public E getElementAt(int n3, int n2) {
                throw new IndexOutOfBoundsException("No getting from access with no X size!");
            }

            @Override
            @NotNull
            public TwoDimensionalAccess<E> transposed() {
                return TwoDimensionalAccess.zeroY(n);
            }

            @Override
            public void changeAll(@NotNull BiFunction<? super E, int[], ? extends E> biFunction) {
            }

            @Override
            public void changeAll(@NotNull Function<? super E, ? extends E> function) {
            }

            @Override
            public MultiDimensionalAccess<E> setAll(@NotNull Function<int[], ? extends E> function) {
                return this;
            }

            @Override
            public long getNumElements() {
                return 0L;
            }
        };
    }

    @NotNull
    public static <E> TwoDimensionalAccess<E> zeroY(final int n) {
        if (n == 0) {
            return TwoDimensionalAccess.empty();
        }
        if (n < 0) {
            throw new IllegalArgumentException("numX has to be non-negative!");
        }
        return new TwoDimensionalAccess<E>(){

            @Override
            public void setElementAt(E e, int n3, int n2) {
                throw new IndexOutOfBoundsException("No setting for access with no Y size!");
            }

            @Override
            public int sizeX() {
                return n;
            }

            @Override
            public int sizeY() {
                return 0;
            }

            @Override
            public E getElementAt(int n3, int n2) {
                throw new IndexOutOfBoundsException("No getting from access with no Y size!");
            }

            @Override
            @NotNull
            public TwoDimensionalAccess<E> transposed() {
                return TwoDimensionalAccess.zeroX(n);
            }

            @Override
            public void changeAll(@NotNull BiFunction<? super E, int[], ? extends E> biFunction) {
            }

            @Override
            public void changeAll(@NotNull Function<? super E, ? extends E> function) {
            }

            @Override
            public MultiDimensionalAccess<E> setAll(@NotNull Function<int[], ? extends E> function) {
                return this;
            }

            @Override
            public long getNumElements() {
                return 0L;
            }
        };
    }

    @NotNull
    public static <E> TwoDimensionalAccess<E> createNulled(int n, int n2) {
        if (n == 0) {
            return TwoDimensionalAccess.zeroX(n2);
        }
        if (n2 == 0) {
            return TwoDimensionalAccess.zeroY(n);
        }
        return new TwoDimensionalArray(n, n2);
    }

    @NotNull
    public static <E> TwoDimensionalAccess<E> createConstant(@Nullable E e, int n, int n2) {
        return e == null ? TwoDimensionalAccess.createNulled(n, n2) : TwoDimensionalAccess.createSupplied(() -> e, n, n2);
    }

    @NotNull
    public static <E> TwoDimensionalAccess<E> createSupplied(@NotNull Supplier<? extends E> supplier, int n, int n2) {
        if (n == 0) {
            return TwoDimensionalAccess.zeroX(n2);
        }
        if (n2 == 0) {
            return TwoDimensionalAccess.zeroY(n);
        }
        return new TwoDimensionalArray<E>(supplier, n, n2);
    }

    @NotNull
    public static <E> TwoDimensionalAccess<E> createIndexed(@NotNull BiFunction<Integer, Integer, ? extends E> biFunction, int n, int n2) {
        if (n == 0) {
            return TwoDimensionalAccess.zeroX(n2);
        }
        if (n2 == 0) {
            return TwoDimensionalAccess.zeroY(n);
        }
        TwoDimensionalArray<E> twoDimensionalArray = new TwoDimensionalArray<E>(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                twoDimensionalArray.setElementAt(biFunction.apply(i, j), i, j);
            }
        }
        return twoDimensionalArray;
    }
}

