/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.mda.ThreeDimensionalReadAccess;
import de.caff.generics.mda.TwoDimensionalShortReadAccess;

public interface ThreeDimensionalShortReadAccess
extends ThreeDimensionalReadAccess<Short> {
    public static final ThreeDimensionalShortReadAccess EMPTY = new ThreeDimensionalShortReadAccess(){

        @Override
        public short getValueAt(int n, int n2, int n3) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int sizeX() {
            return 0;
        }

        @Override
        public int sizeY() {
            return 0;
        }

        @Override
        public int sizeZ() {
            return 0;
        }
    };

    @NotNull
    public static ThreeDimensionalShortReadAccess singleton(final short s) {
        return new ThreeDimensionalShortReadAccess(){

            @Override
            public short getValueAt(int n, int n2, int n3) {
                if (n != 0 || n2 != 0 || n3 != 0) {
                    throw new IllegalArgumentException();
                }
                return s;
            }

            @Override
            public int sizeX() {
                return 1;
            }

            @Override
            public int sizeY() {
                return 1;
            }

            @Override
            public int sizeZ() {
                return 1;
            }
        };
    }

    public short getValueAt(int var1, int var2, int var3);

    @Override
    @NotNull
    default public Short getElementAt(int n, int n2, int n3) {
        return this.getValueAt(n, n2, n3);
    }

    @NotNull
    default public TwoDimensionalShortReadAccess subAtX(final int n) {
        return new TwoDimensionalShortReadAccess(){

            @Override
            public short getValueAt(int n3, int n2) {
                return ThreeDimensionalShortReadAccess.this.getValueAt(n, n3, n2);
            }

            @Override
            public int sizeX() {
                return ThreeDimensionalShortReadAccess.this.sizeY();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalShortReadAccess.this.sizeZ();
            }
        };
    }

    @NotNull
    default public TwoDimensionalShortReadAccess subAtY(final int n) {
        return new TwoDimensionalShortReadAccess(){

            @Override
            public short getValueAt(int n3, int n2) {
                return ThreeDimensionalShortReadAccess.this.getValueAt(n3, n, n2);
            }

            @Override
            public int sizeX() {
                return ThreeDimensionalShortReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalShortReadAccess.this.sizeZ();
            }
        };
    }

    @NotNull
    default public TwoDimensionalShortReadAccess subAtZ(final int n) {
        return new TwoDimensionalShortReadAccess(){

            @Override
            public short getValueAt(int n3, int n2) {
                return ThreeDimensionalShortReadAccess.this.getValueAt(n3, n2, n);
            }

            @Override
            public int sizeX() {
                return ThreeDimensionalShortReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalShortReadAccess.this.sizeY();
            }
        };
    }
}

