/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToShortFunction3;
import de.caff.generics.mda.ThreeDimensionalShortAccess;

public class ThreeDimensionalShortArray
implements ThreeDimensionalShortAccess {
    @NotNull
    private final short[][][] values;

    public ThreeDimensionalShortArray(int n, int n2, int n3) {
        this.values = new short[n][n2][n3];
    }

    public ThreeDimensionalShortArray(int n, int n2, int n3, @NotNull IntToShortFunction3 intToShortFunction3) {
        this(n, n2, n3);
        this.fillValuesByIndex(intToShortFunction3);
    }

    public ThreeDimensionalShortArray(int n, int n2, short ... sArray) {
        if (n <= 0 || sArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (sArray.length % n2 != 0 || sArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize*zSize values!");
        }
        int n3 = n * n2;
        int n4 = sArray.length / n3;
        this.values = new short[n4][n][n2];
        for (int i = 0; i < sArray.length; ++i) {
            int n5 = i / n3;
            int n6 = i % n3 / n2;
            int n7 = i % n2;
            this.values[n5][n6][n7] = sArray[n7];
        }
    }

    @Override
    public void setValueAt(short s, int n, int n2, int n3) {
        this.values[n][n2][n3] = s;
    }

    @Override
    public short getValueAt(int n, int n2, int n3) {
        return this.values[n][n2][n3];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }

    @Override
    public int sizeZ() {
        return this.values[0][0].length;
    }
}

