/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.Function1;
import de.caff.generics.function.Procedure1;
import de.caff.generics.function.Procedure2;
import de.caff.generics.mda.MultiDimensionalReadAccess;
import de.caff.generics.mda.TwoDimensionalReadAccess;

public interface ThreeDimensionalReadAccess<T>
extends MultiDimensionalReadAccess<T> {
    public static final ThreeDimensionalReadAccess<?> EMPTY = new ThreeDimensionalReadAccess<Object>(){

        @Override
        public int sizeX() {
            return 0;
        }

        @Override
        public int sizeY() {
            return 0;
        }

        @Override
        public int sizeZ() {
            return 0;
        }

        @Override
        public Object getElementAt(int n, int n2, int n3) {
            throw new IndexOutOfBoundsException();
        }
    };

    public int sizeX();

    public int sizeY();

    public int sizeZ();

    public T getElementAt(int var1, int var2, int var3);

    @Override
    default public T getElement(int ... nArray) {
        if (nArray.length != 3) {
            throw new IllegalArgumentException("Need 3 indexes for 3-dimensional array!");
        }
        return this.getElementAt(nArray[0], nArray[1], nArray[2]);
    }

    @NotNull
    default public TwoDimensionalReadAccess<T> subAtX(final int n) {
        return new TwoDimensionalReadAccess<T>(){

            @Override
            public int sizeX() {
                return ThreeDimensionalReadAccess.this.sizeY();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalReadAccess.this.sizeZ();
            }

            @Override
            public T getElementAt(int n3, int n2) {
                return ThreeDimensionalReadAccess.this.getElementAt(n, n3, n2);
            }
        };
    }

    @NotNull
    default public TwoDimensionalReadAccess<T> subAtY(final int n) {
        return new TwoDimensionalReadAccess<T>(){

            @Override
            public int sizeX() {
                return ThreeDimensionalReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalReadAccess.this.sizeZ();
            }

            @Override
            public T getElementAt(int n3, int n2) {
                return ThreeDimensionalReadAccess.this.getElementAt(n3, n, n2);
            }
        };
    }

    @NotNull
    default public TwoDimensionalReadAccess<T> subAtZ(final int n) {
        return new TwoDimensionalReadAccess<T>(){

            @Override
            public int sizeX() {
                return ThreeDimensionalReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalReadAccess.this.sizeY();
            }

            @Override
            public T getElementAt(int n3, int n2) {
                return ThreeDimensionalReadAccess.this.getElementAt(n3, n2, n);
            }
        };
    }

    @Override
    default public int getNumDimensions() {
        return 3;
    }

    @Override
    default public int getSize(int n) {
        switch (n) {
            case 0: {
                return this.sizeX();
            }
            case 1: {
                return this.sizeY();
            }
            case 2: {
                return this.sizeZ();
            }
        }
        throw new IllegalArgumentException("There are only 3 dimensions!");
    }

    @Override
    @NotNull
    default public int[] getSizes() {
        return new int[]{this.sizeX(), this.sizeY(), this.sizeZ()};
    }

    @Override
    default public long getNumElements() {
        return (long)this.sizeX() * (long)this.sizeY() * (long)this.sizeZ();
    }

    @NotNull
    default public <TOUT> ThreeDimensionalReadAccess<TOUT> view(final @NotNull Function1<TOUT, T> function1) {
        return new ThreeDimensionalReadAccess<TOUT>(){

            @Override
            public int sizeX() {
                return ThreeDimensionalReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalReadAccess.this.sizeY();
            }

            @Override
            public int sizeZ() {
                return ThreeDimensionalReadAccess.this.sizeZ();
            }

            @Override
            public TOUT getElementAt(int n, int n2, int n3) {
                return function1.apply(ThreeDimensionalReadAccess.this.getElementAt(n, n2, n3));
            }
        };
    }

    @Override
    default public void visitAll(@NotNull Procedure2<? super T, int[]> procedure2) {
        int n = this.sizeX();
        int n2 = this.sizeY();
        int n3 = this.sizeZ();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    procedure2.apply(this.getElementAt(i, j, k), new int[]{i, j, k});
                }
            }
        }
    }

    @Override
    default public void visitAll(@NotNull Procedure1<? super T> procedure1) {
        int n = this.sizeX();
        int n2 = this.sizeY();
        int n3 = this.sizeZ();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    procedure1.apply(this.getElementAt(i, j, k));
                }
            }
        }
    }

    @NotNull
    public static <E> ThreeDimensionalReadAccess<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> ThreeDimensionalReadAccess<E> singleton(final E e) {
        return new ThreeDimensionalReadAccess<E>(){

            @Override
            public int sizeX() {
                return 1;
            }

            @Override
            public int sizeY() {
                return 1;
            }

            @Override
            public int sizeZ() {
                return 1;
            }

            @Override
            public E getElementAt(int n, int n2, int n3) {
                if (n != 0 || n2 != 0 || n3 != 0) {
                    throw new IndexOutOfBoundsException();
                }
                return e;
            }
        };
    }
}

