/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToLongFunction3;
import de.caff.generics.mda.ThreeDimensionalLongAccess;

public class ThreeDimensionalLongArray
implements ThreeDimensionalLongAccess {
    @NotNull
    private final long[][][] values;

    public ThreeDimensionalLongArray(int n, int n2, int n3) {
        this.values = new long[n][n2][n3];
    }

    public ThreeDimensionalLongArray(int n, int n2, int n3, @NotNull IntToLongFunction3 intToLongFunction3) {
        this(n, n2, n3);
        this.fillValuesByIndex(intToLongFunction3);
    }

    public ThreeDimensionalLongArray(int n, int n2, long ... lArray) {
        if (n <= 0 || lArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (lArray.length % n2 != 0 || lArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize*zSize values!");
        }
        int n3 = n * n2;
        int n4 = lArray.length / n3;
        this.values = new long[n4][n][n2];
        for (int i = 0; i < lArray.length; ++i) {
            int n5 = i / n3;
            int n6 = i % n3 / n2;
            int n7 = i % n2;
            this.values[n5][n6][n7] = lArray[n7];
        }
    }

    @Override
    public void setValueAt(long l, int n, int n2, int n3) {
        this.values[n][n2][n3] = l;
    }

    @Override
    public long getValueAt(int n, int n2, int n3) {
        return this.values[n][n2][n3];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }

    @Override
    public int sizeZ() {
        return this.values[0][0].length;
    }
}

