/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToIntFunction3;
import de.caff.generics.mda.ThreeDimensionalIntAccess;

public class ThreeDimensionalIntArray
implements ThreeDimensionalIntAccess {
    @NotNull
    private final int[][][] values;

    public ThreeDimensionalIntArray(int n, int n2, int n3) {
        this.values = new int[n][n2][n3];
    }

    public ThreeDimensionalIntArray(int n, int n2, int n3, @NotNull IntToIntFunction3 intToIntFunction3) {
        this(n, n2, n3);
        this.fillValuesByIndex(intToIntFunction3);
    }

    public ThreeDimensionalIntArray(int n, int n2, int ... nArray) {
        if (n <= 0 || nArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (nArray.length % n2 != 0 || nArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize*zSize values!");
        }
        int n3 = n * n2;
        int n4 = nArray.length / n3;
        this.values = new int[n4][n][n2];
        for (int i = 0; i < nArray.length; ++i) {
            int n5 = i / n3;
            int n6 = i % n3 / n2;
            int n7 = i % n2;
            this.values[n5][n6][n7] = nArray[n7];
        }
    }

    @Override
    public void setValueAt(int n, int n2, int n3, int n4) {
        this.values[n2][n3][n4] = n;
    }

    @Override
    public int getValueAt(int n, int n2, int n3) {
        return this.values[n][n2][n3];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }

    @Override
    public int sizeZ() {
        return this.values[0][0].length;
    }
}

