/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.mda.ThreeDimensionalReadAccess;
import de.caff.generics.mda.TwoDimensionalFloatReadAccess;

public interface ThreeDimensionalFloatReadAccess
extends ThreeDimensionalReadAccess<Float> {
    public static final ThreeDimensionalFloatReadAccess EMPTY = new ThreeDimensionalFloatReadAccess(){

        @Override
        public float getValueAt(int n, int n2, int n3) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int sizeX() {
            return 0;
        }

        @Override
        public int sizeY() {
            return 0;
        }

        @Override
        public int sizeZ() {
            return 0;
        }
    };

    @NotNull
    public static ThreeDimensionalFloatReadAccess singleton(final float f) {
        return new ThreeDimensionalFloatReadAccess(){

            @Override
            public float getValueAt(int n, int n2, int n3) {
                if (n != 0 || n2 != 0 || n3 != 0) {
                    throw new IllegalArgumentException();
                }
                return f;
            }

            @Override
            public int sizeX() {
                return 1;
            }

            @Override
            public int sizeY() {
                return 1;
            }

            @Override
            public int sizeZ() {
                return 1;
            }
        };
    }

    public float getValueAt(int var1, int var2, int var3);

    @Override
    @NotNull
    default public Float getElementAt(int n, int n2, int n3) {
        return Float.valueOf(this.getValueAt(n, n2, n3));
    }

    @NotNull
    default public TwoDimensionalFloatReadAccess subAtX(final int n) {
        return new TwoDimensionalFloatReadAccess(){

            @Override
            public float getValueAt(int n3, int n2) {
                return ThreeDimensionalFloatReadAccess.this.getValueAt(n, n3, n2);
            }

            @Override
            public int sizeX() {
                return ThreeDimensionalFloatReadAccess.this.sizeY();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalFloatReadAccess.this.sizeZ();
            }
        };
    }

    @NotNull
    default public TwoDimensionalFloatReadAccess subAtY(final int n) {
        return new TwoDimensionalFloatReadAccess(){

            @Override
            public float getValueAt(int n3, int n2) {
                return ThreeDimensionalFloatReadAccess.this.getValueAt(n3, n, n2);
            }

            @Override
            public int sizeX() {
                return ThreeDimensionalFloatReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalFloatReadAccess.this.sizeZ();
            }
        };
    }

    @NotNull
    default public TwoDimensionalFloatReadAccess subAtZ(final int n) {
        return new TwoDimensionalFloatReadAccess(){

            @Override
            public float getValueAt(int n3, int n2) {
                return ThreeDimensionalFloatReadAccess.this.getValueAt(n3, n2, n);
            }

            @Override
            public int sizeX() {
                return ThreeDimensionalFloatReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalFloatReadAccess.this.sizeY();
            }
        };
    }
}

