/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToFloatFunction3;
import de.caff.generics.mda.ThreeDimensionalFloatAccess;

public class ThreeDimensionalFloatArray
implements ThreeDimensionalFloatAccess {
    @NotNull
    private final float[][][] values;

    public ThreeDimensionalFloatArray(int n, int n2, int n3) {
        this.values = new float[n][n2][n3];
    }

    public ThreeDimensionalFloatArray(int n, int n2, int n3, @NotNull IntToFloatFunction3 intToFloatFunction3) {
        this(n, n2, n3);
        this.fillValuesByIndex(intToFloatFunction3);
    }

    public ThreeDimensionalFloatArray(int n, int n2, float ... fArray) {
        if (n <= 0 || fArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (fArray.length % n2 != 0 || fArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize*zSize values!");
        }
        int n3 = n * n2;
        int n4 = fArray.length / n3;
        this.values = new float[n4][n][n2];
        for (int i = 0; i < fArray.length; ++i) {
            int n5 = i / n3;
            int n6 = i % n3 / n2;
            int n7 = i % n2;
            this.values[n5][n6][n7] = fArray[n7];
        }
    }

    @Override
    public void setValueAt(float f, int n, int n2, int n3) {
        this.values[n][n2][n3] = f;
    }

    @Override
    public float getValueAt(int n, int n2, int n3) {
        return this.values[n][n2][n3];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }

    @Override
    public int sizeZ() {
        return this.values[0][0].length;
    }
}

