/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.mda.ThreeDimensionalReadAccess;
import de.caff.generics.mda.TwoDimensionalDoubleReadAccess;

public interface ThreeDimensionalDoubleReadAccess
extends ThreeDimensionalReadAccess<Double> {
    public static final ThreeDimensionalDoubleReadAccess EMPTY = new ThreeDimensionalDoubleReadAccess(){

        @Override
        public double getValueAt(int n, int n2, int n3) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int sizeX() {
            return 0;
        }

        @Override
        public int sizeY() {
            return 0;
        }

        @Override
        public int sizeZ() {
            return 0;
        }
    };

    @NotNull
    public static ThreeDimensionalDoubleReadAccess singleton(final double d) {
        return new ThreeDimensionalDoubleReadAccess(){

            @Override
            public double getValueAt(int n, int n2, int n3) {
                if (n != 0 || n2 != 0 || n3 != 0) {
                    throw new IllegalArgumentException();
                }
                return d;
            }

            @Override
            public int sizeX() {
                return 1;
            }

            @Override
            public int sizeY() {
                return 1;
            }

            @Override
            public int sizeZ() {
                return 1;
            }
        };
    }

    public double getValueAt(int var1, int var2, int var3);

    @Override
    @NotNull
    default public Double getElementAt(int n, int n2, int n3) {
        return this.getValueAt(n, n2, n3);
    }

    @NotNull
    default public TwoDimensionalDoubleReadAccess subAtX(final int n) {
        return new TwoDimensionalDoubleReadAccess(){

            @Override
            public double getValueAt(int n3, int n2) {
                return ThreeDimensionalDoubleReadAccess.this.getValueAt(n, n3, n2);
            }

            @Override
            public int sizeX() {
                return ThreeDimensionalDoubleReadAccess.this.sizeY();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalDoubleReadAccess.this.sizeZ();
            }
        };
    }

    @NotNull
    default public TwoDimensionalDoubleReadAccess subAtY(final int n) {
        return new TwoDimensionalDoubleReadAccess(){

            @Override
            public double getValueAt(int n3, int n2) {
                return ThreeDimensionalDoubleReadAccess.this.getValueAt(n3, n, n2);
            }

            @Override
            public int sizeX() {
                return ThreeDimensionalDoubleReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalDoubleReadAccess.this.sizeZ();
            }
        };
    }

    @NotNull
    default public TwoDimensionalDoubleReadAccess subAtZ(final int n) {
        return new TwoDimensionalDoubleReadAccess(){

            @Override
            public double getValueAt(int n3, int n2) {
                return ThreeDimensionalDoubleReadAccess.this.getValueAt(n3, n2, n);
            }

            @Override
            public int sizeX() {
                return ThreeDimensionalDoubleReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalDoubleReadAccess.this.sizeY();
            }
        };
    }
}

