/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToDoubleFunction3;
import de.caff.generics.mda.ThreeDimensionalDoubleAccess;

public class ThreeDimensionalDoubleArray
implements ThreeDimensionalDoubleAccess {
    @NotNull
    private final double[][][] values;

    public ThreeDimensionalDoubleArray(int n, int n2, int n3) {
        this.values = new double[n][n2][n3];
    }

    public ThreeDimensionalDoubleArray(int n, int n2, int n3, @NotNull IntToDoubleFunction3 intToDoubleFunction3) {
        this(n, n2, n3);
        this.fillValuesByIndex(intToDoubleFunction3);
    }

    public ThreeDimensionalDoubleArray(int n, int n2, double ... dArray) {
        if (n <= 0 || dArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (dArray.length % n2 != 0 || dArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize*zSize values!");
        }
        int n3 = n * n2;
        int n4 = dArray.length / n3;
        this.values = new double[n4][n][n2];
        for (int i = 0; i < dArray.length; ++i) {
            int n5 = i / n3;
            int n6 = i % n3 / n2;
            int n7 = i % n2;
            this.values[n5][n6][n7] = dArray[n7];
        }
    }

    @Override
    public void setValueAt(double d, int n, int n2, int n3) {
        this.values[n][n2][n3] = d;
    }

    @Override
    public double getValueAt(int n, int n2, int n3) {
        return this.values[n][n2][n3];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }

    @Override
    public int sizeZ() {
        return this.values[0][0].length;
    }
}

