/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.mda.ThreeDimensionalReadAccess;
import de.caff.generics.mda.TwoDimensionalCharReadAccess;

public interface ThreeDimensionalCharReadAccess
extends ThreeDimensionalReadAccess<Character> {
    public static final ThreeDimensionalCharReadAccess EMPTY = new ThreeDimensionalCharReadAccess(){

        @Override
        public char getValueAt(int n, int n2, int n3) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int sizeX() {
            return 0;
        }

        @Override
        public int sizeY() {
            return 0;
        }

        @Override
        public int sizeZ() {
            return 0;
        }
    };

    @NotNull
    public static ThreeDimensionalCharReadAccess singleton(final char c) {
        return new ThreeDimensionalCharReadAccess(){

            @Override
            public char getValueAt(int n, int n2, int n3) {
                if (n != 0 || n2 != 0 || n3 != 0) {
                    throw new IllegalArgumentException();
                }
                return c;
            }

            @Override
            public int sizeX() {
                return 1;
            }

            @Override
            public int sizeY() {
                return 1;
            }

            @Override
            public int sizeZ() {
                return 1;
            }
        };
    }

    public char getValueAt(int var1, int var2, int var3);

    @Override
    @NotNull
    default public Character getElementAt(int n, int n2, int n3) {
        return Character.valueOf(this.getValueAt(n, n2, n3));
    }

    @NotNull
    default public TwoDimensionalCharReadAccess subAtX(final int n) {
        return new TwoDimensionalCharReadAccess(){

            @Override
            public char getValueAt(int n3, int n2) {
                return ThreeDimensionalCharReadAccess.this.getValueAt(n, n3, n2);
            }

            @Override
            public int sizeX() {
                return ThreeDimensionalCharReadAccess.this.sizeY();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalCharReadAccess.this.sizeZ();
            }
        };
    }

    @NotNull
    default public TwoDimensionalCharReadAccess subAtY(final int n) {
        return new TwoDimensionalCharReadAccess(){

            @Override
            public char getValueAt(int n3, int n2) {
                return ThreeDimensionalCharReadAccess.this.getValueAt(n3, n, n2);
            }

            @Override
            public int sizeX() {
                return ThreeDimensionalCharReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalCharReadAccess.this.sizeZ();
            }
        };
    }

    @NotNull
    default public TwoDimensionalCharReadAccess subAtZ(final int n) {
        return new TwoDimensionalCharReadAccess(){

            @Override
            public char getValueAt(int n3, int n2) {
                return ThreeDimensionalCharReadAccess.this.getValueAt(n3, n2, n);
            }

            @Override
            public int sizeX() {
                return ThreeDimensionalCharReadAccess.this.sizeX();
            }

            @Override
            public int sizeY() {
                return ThreeDimensionalCharReadAccess.this.sizeY();
            }
        };
    }
}

