/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToCharFunction3;
import de.caff.generics.mda.ThreeDimensionalCharAccess;

public class ThreeDimensionalCharArray
implements ThreeDimensionalCharAccess {
    @NotNull
    private final char[][][] values;

    public ThreeDimensionalCharArray(int n, int n2, int n3) {
        this.values = new char[n][n2][n3];
    }

    public ThreeDimensionalCharArray(int n, int n2, int n3, @NotNull IntToCharFunction3 intToCharFunction3) {
        this(n, n2, n3);
        this.fillValuesByIndex(intToCharFunction3);
    }

    public ThreeDimensionalCharArray(int n, int n2, char ... cArray) {
        if (n <= 0 || cArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (cArray.length % n2 != 0 || cArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize*zSize values!");
        }
        int n3 = n * n2;
        int n4 = cArray.length / n3;
        this.values = new char[n4][n][n2];
        for (int i = 0; i < cArray.length; ++i) {
            int n5 = i / n3;
            int n6 = i % n3 / n2;
            int n7 = i % n2;
            this.values[n5][n6][n7] = cArray[n7];
        }
    }

    @Override
    public void setValueAt(char c, int n, int n2, int n3) {
        this.values[n][n2][n3] = c;
    }

    @Override
    public char getValueAt(int n, int n2, int n3) {
        return this.values[n][n2][n3];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }

    @Override
    public int sizeZ() {
        return this.values[0][0].length;
    }
}

