/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToByteFunction3;
import de.caff.generics.mda.ThreeDimensionalByteAccess;

public class ThreeDimensionalByteArray
implements ThreeDimensionalByteAccess {
    @NotNull
    private final byte[][][] values;

    public ThreeDimensionalByteArray(int n, int n2, int n3) {
        this.values = new byte[n][n2][n3];
    }

    public ThreeDimensionalByteArray(int n, int n2, int n3, @NotNull IntToByteFunction3 intToByteFunction3) {
        this(n, n2, n3);
        this.fillValuesByIndex(intToByteFunction3);
    }

    public ThreeDimensionalByteArray(int n, int n2, byte ... byArray) {
        if (n <= 0 || byArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (byArray.length % n2 != 0 || byArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize*zSize values!");
        }
        int n3 = n * n2;
        int n4 = byArray.length / n3;
        this.values = new byte[n4][n][n2];
        for (int i = 0; i < byArray.length; ++i) {
            int n5 = i / n3;
            int n6 = i % n3 / n2;
            int n7 = i % n2;
            this.values[n5][n6][n7] = byArray[n7];
        }
    }

    @Override
    public void setValueAt(byte by, int n, int n2, int n3) {
        this.values[n][n2][n3] = by;
    }

    @Override
    public byte getValueAt(int n, int n2, int n3) {
        return this.values[n][n2][n3];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }

    @Override
    public int sizeZ() {
        return this.values[0][0].length;
    }
}

