/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntPredicate3;
import de.caff.generics.mda.ThreeDimensionalBooleanAccess;

public class ThreeDimensionalBooleanArray
implements ThreeDimensionalBooleanAccess {
    @NotNull
    private final boolean[][][] values;

    public ThreeDimensionalBooleanArray(int n, int n2, int n3) {
        this.values = new boolean[n][n2][n3];
    }

    public ThreeDimensionalBooleanArray(int n, int n2, int n3, @NotNull IntPredicate3 intPredicate3) {
        this(n, n2, n3);
        this.fillValuesByIndex(intPredicate3);
    }

    public ThreeDimensionalBooleanArray(int n, int n2, boolean ... blArray) {
        if (n <= 0 || blArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (blArray.length % n2 != 0 || blArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize*zSize values!");
        }
        int n3 = n * n2;
        int n4 = blArray.length / n3;
        this.values = new boolean[n4][n][n2];
        for (int i = 0; i < blArray.length; ++i) {
            int n5 = i / n3;
            int n6 = i % n3 / n2;
            int n7 = i % n2;
            this.values[n5][n6][n7] = blArray[n7];
        }
    }

    @Override
    public void setValueAt(boolean bl, int n, int n2, int n3) {
        this.values[n][n2][n3] = bl;
    }

    @Override
    public boolean getValueAt(int n, int n2, int n3) {
        return this.values[n][n2][n3];
    }

    @Override
    public int sizeX() {
        return this.values.length;
    }

    @Override
    public int sizeY() {
        return this.values[0].length;
    }

    @Override
    public int sizeZ() {
        return this.values[0][0].length;
    }
}

