/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.mda.ThreeDimensionalAccess;

public class ThreeDimensionalArray<T>
implements ThreeDimensionalAccess<T> {
    @NotNull
    private final Object[][][] elements;

    public ThreeDimensionalArray(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        this.elements = new Object[n][n2][n3];
    }

    public ThreeDimensionalArray(@NotNull ThreeDimensionalAccess<T> threeDimensionalAccess) {
        this.elements = new Object[threeDimensionalAccess.sizeX()][threeDimensionalAccess.sizeY()][threeDimensionalAccess.sizeZ()];
        for (int i = threeDimensionalAccess.sizeX() - 1; i >= 0; --i) {
            Object[][] objectArray = this.elements[i];
            for (int j = threeDimensionalAccess.sizeY() - 1; j >= 0; --j) {
                Object[] objectArray2 = objectArray[j];
                for (int k = threeDimensionalAccess.sizeZ() - 1; k >= 0; --k) {
                    objectArray2[k] = threeDimensionalAccess.getElementAt(i, j, k);
                }
            }
        }
    }

    @Override
    public void setElementAt(T t, int n, int n2, int n3) {
        this.elements[n][n2][n3] = t;
    }

    @Override
    public int sizeX() {
        return this.elements.length;
    }

    @Override
    public int sizeY() {
        return this.elements[0].length;
    }

    @Override
    public int sizeZ() {
        return this.elements[0][0].length;
    }

    @Override
    public T getElementAt(int n, int n2, int n3) {
        return (T)this.elements[n][n2];
    }
}

