/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToShortFunction2;
import de.caff.generics.mda.TwoDimensionalShortAccess;
import de.caff.generics.mda.TwoDimensionalShortReadAccess;

public class SmallTwoDimensionalShortArray
extends TwoDimensionalShortReadAccess.Base
implements TwoDimensionalShortAccess {
    @NotNull
    private final short[] values;
    private final int xSize;
    private final int ySize;

    public SmallTwoDimensionalShortArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Sizes have to be non-negative!");
        }
        if (Integer.MAX_VALUE / n < n2) {
            throw new IllegalArgumentException("Sizes overflow the range of integer. Use TwoDimensionalShortArray instead!");
        }
        this.values = new short[n * n2];
        this.xSize = n;
        this.ySize = n2;
    }

    public SmallTwoDimensionalShortArray(int n, int n2, @NotNull IntToShortFunction2 intToShortFunction2) {
        this(n, n2);
        this.fillValuesByIndex(intToShortFunction2);
    }

    public SmallTwoDimensionalShortArray(int n, short ... sArray) {
        if (n <= 0 || sArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (sArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = (short[])sArray.clone();
        this.xSize = sArray.length / n;
        this.ySize = n;
    }

    public SmallTwoDimensionalShortArray(@NotNull TwoDimensionalShortReadAccess twoDimensionalShortReadAccess) {
        this(twoDimensionalShortReadAccess.sizeX(), twoDimensionalShortReadAccess.sizeY(), twoDimensionalShortReadAccess::getValueAt);
    }

    private SmallTwoDimensionalShortArray(@NotNull SmallTwoDimensionalShortArray smallTwoDimensionalShortArray) {
        this.values = (short[])smallTwoDimensionalShortArray.values.clone();
        this.xSize = smallTwoDimensionalShortArray.xSize;
        this.ySize = smallTwoDimensionalShortArray.ySize;
    }

    public void invertX() {
        short[] sArray = new short[this.ySize];
        for (int i = 0; i < this.xSize / 2; ++i) {
            int n = i * this.ySize;
            int n2 = (this.xSize - i - 1) * this.ySize;
            System.arraycopy(this.values, n, sArray, 0, this.ySize);
            System.arraycopy(this.values, n2, this.values, n, this.ySize);
            System.arraycopy(sArray, 0, this.values, n2, this.ySize);
        }
    }

    public void invertY() {
        for (int i = 0; i < this.xSize; ++i) {
            int n = i * this.ySize;
            for (int j = 0; j < this.ySize / 2; ++j) {
                int n2 = n + j;
                int n3 = n + this.ySize - j - 1;
                short s = this.values[n2];
                this.values[n2] = this.values[n3];
                this.values[n3] = s;
            }
        }
    }

    private void checkIndices(int n, int n2) {
        if (n >= this.xSize || n < 0) {
            throw new IndexOutOfBoundsException(String.format("ix (%d) is out of range [0, %d[!", n, this.xSize));
        }
        if (n2 >= this.ySize || n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("iy (%d) is out of range [0, %d[!", n2, this.ySize));
        }
    }

    @Override
    public void setValueAt(short s, int n, int n2) {
        this.checkIndices(n, n2);
        this.values[n * this.ySize + n2] = s;
    }

    @Override
    public short getValueAt(int n, int n2) {
        this.checkIndices(n, n2);
        return this.values[n * this.ySize + n2];
    }

    @Override
    public int sizeX() {
        return this.xSize;
    }

    @Override
    public int sizeY() {
        return this.ySize;
    }

    @NotNull
    public SmallTwoDimensionalShortArray copy() {
        return new SmallTwoDimensionalShortArray(this);
    }
}

