/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToLongFunction2;
import de.caff.generics.mda.TwoDimensionalLongAccess;
import de.caff.generics.mda.TwoDimensionalLongReadAccess;

public class SmallTwoDimensionalLongArray
extends TwoDimensionalLongReadAccess.Base
implements TwoDimensionalLongAccess {
    @NotNull
    private final long[] values;
    private final int xSize;
    private final int ySize;

    public SmallTwoDimensionalLongArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Sizes have to be non-negative!");
        }
        if (Integer.MAX_VALUE / n < n2) {
            throw new IllegalArgumentException("Sizes overflow the range of integer. Use TwoDimensionalLongArray instead!");
        }
        this.values = new long[n * n2];
        this.xSize = n;
        this.ySize = n2;
    }

    public SmallTwoDimensionalLongArray(int n, int n2, @NotNull IntToLongFunction2 intToLongFunction2) {
        this(n, n2);
        this.fillValuesByIndex(intToLongFunction2);
    }

    public SmallTwoDimensionalLongArray(int n, long ... lArray) {
        if (n <= 0 || lArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (lArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = (long[])lArray.clone();
        this.xSize = lArray.length / n;
        this.ySize = n;
    }

    public SmallTwoDimensionalLongArray(@NotNull TwoDimensionalLongReadAccess twoDimensionalLongReadAccess) {
        this(twoDimensionalLongReadAccess.sizeX(), twoDimensionalLongReadAccess.sizeY(), twoDimensionalLongReadAccess::getValueAt);
    }

    private SmallTwoDimensionalLongArray(@NotNull SmallTwoDimensionalLongArray smallTwoDimensionalLongArray) {
        this.values = (long[])smallTwoDimensionalLongArray.values.clone();
        this.xSize = smallTwoDimensionalLongArray.xSize;
        this.ySize = smallTwoDimensionalLongArray.ySize;
    }

    public void invertX() {
        long[] lArray = new long[this.ySize];
        for (int i = 0; i < this.xSize / 2; ++i) {
            int n = i * this.ySize;
            int n2 = (this.xSize - i - 1) * this.ySize;
            System.arraycopy(this.values, n, lArray, 0, this.ySize);
            System.arraycopy(this.values, n2, this.values, n, this.ySize);
            System.arraycopy(lArray, 0, this.values, n2, this.ySize);
        }
    }

    public void invertY() {
        for (int i = 0; i < this.xSize; ++i) {
            int n = i * this.ySize;
            for (int j = 0; j < this.ySize / 2; ++j) {
                int n2 = n + j;
                int n3 = n + this.ySize - j - 1;
                long l = this.values[n2];
                this.values[n2] = this.values[n3];
                this.values[n3] = l;
            }
        }
    }

    private void checkIndices(int n, int n2) {
        if (n >= this.xSize || n < 0) {
            throw new IndexOutOfBoundsException(String.format("ix (%d) is out of range [0, %d[!", n, this.xSize));
        }
        if (n2 >= this.ySize || n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("iy (%d) is out of range [0, %d[!", n2, this.ySize));
        }
    }

    @Override
    public void setValueAt(long l, int n, int n2) {
        this.checkIndices(n, n2);
        this.values[n * this.ySize + n2] = l;
    }

    @Override
    public long getValueAt(int n, int n2) {
        this.checkIndices(n, n2);
        return this.values[n * this.ySize + n2];
    }

    @Override
    public int sizeX() {
        return this.xSize;
    }

    @Override
    public int sizeY() {
        return this.ySize;
    }

    @NotNull
    public SmallTwoDimensionalLongArray copy() {
        return new SmallTwoDimensionalLongArray(this);
    }
}

