/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.mda.TwoDimensionalIntAccess;
import de.caff.generics.mda.TwoDimensionalIntReadAccess;
import java.util.function.IntBinaryOperator;

public class SmallTwoDimensionalIntArray
extends TwoDimensionalIntReadAccess.Base
implements TwoDimensionalIntAccess {
    @NotNull
    private final int[] values;
    private final int xSize;
    private final int ySize;

    public SmallTwoDimensionalIntArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Sizes have to be non-negative!");
        }
        if (Integer.MAX_VALUE / n < n2) {
            throw new IllegalArgumentException("Sizes overflow the range of integer. Use TwoDimensionalIntArray instead!");
        }
        this.values = new int[n * n2];
        this.xSize = n;
        this.ySize = n2;
    }

    public SmallTwoDimensionalIntArray(int n, int n2, @NotNull IntBinaryOperator intBinaryOperator) {
        this(n, n2);
        this.fillValuesByIndex(intBinaryOperator);
    }

    public SmallTwoDimensionalIntArray(int n, int ... nArray) {
        if (n <= 0 || nArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (nArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = (int[])nArray.clone();
        this.xSize = nArray.length / n;
        this.ySize = n;
    }

    public SmallTwoDimensionalIntArray(@NotNull TwoDimensionalIntReadAccess twoDimensionalIntReadAccess) {
        this(twoDimensionalIntReadAccess.sizeX(), twoDimensionalIntReadAccess.sizeY(), twoDimensionalIntReadAccess::getValueAt);
    }

    private SmallTwoDimensionalIntArray(@NotNull SmallTwoDimensionalIntArray smallTwoDimensionalIntArray) {
        this.values = (int[])smallTwoDimensionalIntArray.values.clone();
        this.xSize = smallTwoDimensionalIntArray.xSize;
        this.ySize = smallTwoDimensionalIntArray.ySize;
    }

    public void invertX() {
        int[] nArray = new int[this.ySize];
        for (int i = 0; i < this.xSize / 2; ++i) {
            int n = i * this.ySize;
            int n2 = (this.xSize - i - 1) * this.ySize;
            System.arraycopy(this.values, n, nArray, 0, this.ySize);
            System.arraycopy(this.values, n2, this.values, n, this.ySize);
            System.arraycopy(nArray, 0, this.values, n2, this.ySize);
        }
    }

    public void invertY() {
        for (int i = 0; i < this.xSize; ++i) {
            int n = i * this.ySize;
            for (int j = 0; j < this.ySize / 2; ++j) {
                int n2 = n + j;
                int n3 = n + this.ySize - j - 1;
                int n4 = this.values[n2];
                this.values[n2] = this.values[n3];
                this.values[n3] = n4;
            }
        }
    }

    private void checkIndices(int n, int n2) {
        if (n >= this.xSize || n < 0) {
            throw new IndexOutOfBoundsException(String.format("ix (%d) is out of range [0, %d[!", n, this.xSize));
        }
        if (n2 >= this.ySize || n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("iy (%d) is out of range [0, %d[!", n2, this.ySize));
        }
    }

    @Override
    public void setValueAt(int n, int n2, int n3) {
        this.checkIndices(n2, n3);
        this.values[n2 * this.ySize + n3] = n;
    }

    @Override
    public int getValueAt(int n, int n2) {
        this.checkIndices(n, n2);
        return this.values[n * this.ySize + n2];
    }

    @Override
    public int sizeX() {
        return this.xSize;
    }

    @Override
    public int sizeY() {
        return this.ySize;
    }

    @NotNull
    public SmallTwoDimensionalIntArray copy() {
        return new SmallTwoDimensionalIntArray(this);
    }
}

