/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToFloatFunction2;
import de.caff.generics.mda.TwoDimensionalFloatAccess;
import de.caff.generics.mda.TwoDimensionalFloatReadAccess;

public class SmallTwoDimensionalFloatArray
extends TwoDimensionalFloatReadAccess.Base
implements TwoDimensionalFloatAccess {
    @NotNull
    private final float[] values;
    private final int xSize;
    private final int ySize;

    public SmallTwoDimensionalFloatArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Sizes have to be non-negative!");
        }
        if (Integer.MAX_VALUE / n < n2) {
            throw new IllegalArgumentException("Sizes overflow the range of integer. Use TwoDimensionalFloatArray instead!");
        }
        this.values = new float[n * n2];
        this.xSize = n;
        this.ySize = n2;
    }

    public SmallTwoDimensionalFloatArray(int n, int n2, @NotNull IntToFloatFunction2 intToFloatFunction2) {
        this(n, n2);
        this.fillValuesByIndex(intToFloatFunction2);
    }

    public SmallTwoDimensionalFloatArray(int n, float ... fArray) {
        if (n <= 0 || fArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (fArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = (float[])fArray.clone();
        this.xSize = fArray.length / n;
        this.ySize = n;
    }

    public SmallTwoDimensionalFloatArray(@NotNull TwoDimensionalFloatReadAccess twoDimensionalFloatReadAccess) {
        this(twoDimensionalFloatReadAccess.sizeX(), twoDimensionalFloatReadAccess.sizeY(), twoDimensionalFloatReadAccess::getValueAt);
    }

    private SmallTwoDimensionalFloatArray(@NotNull SmallTwoDimensionalFloatArray smallTwoDimensionalFloatArray) {
        this.values = (float[])smallTwoDimensionalFloatArray.values.clone();
        this.xSize = smallTwoDimensionalFloatArray.xSize;
        this.ySize = smallTwoDimensionalFloatArray.ySize;
    }

    public void invertX() {
        float[] fArray = new float[this.ySize];
        for (int i = 0; i < this.xSize / 2; ++i) {
            int n = i * this.ySize;
            int n2 = (this.xSize - i - 1) * this.ySize;
            System.arraycopy(this.values, n, fArray, 0, this.ySize);
            System.arraycopy(this.values, n2, this.values, n, this.ySize);
            System.arraycopy(fArray, 0, this.values, n2, this.ySize);
        }
    }

    public void invertY() {
        for (int i = 0; i < this.xSize; ++i) {
            int n = i * this.ySize;
            for (int j = 0; j < this.ySize / 2; ++j) {
                int n2 = n + j;
                int n3 = n + this.ySize - j - 1;
                float f = this.values[n2];
                this.values[n2] = this.values[n3];
                this.values[n3] = f;
            }
        }
    }

    private void checkIndices(int n, int n2) {
        if (n >= this.xSize || n < 0) {
            throw new IndexOutOfBoundsException(String.format("ix (%d) is out of range [0, %d[!", n, this.xSize));
        }
        if (n2 >= this.ySize || n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("iy (%d) is out of range [0, %d[!", n2, this.ySize));
        }
    }

    @Override
    public void setValueAt(float f, int n, int n2) {
        this.checkIndices(n, n2);
        this.values[n * this.ySize + n2] = f;
    }

    @Override
    public float getValueAt(int n, int n2) {
        this.checkIndices(n, n2);
        return this.values[n * this.ySize + n2];
    }

    @Override
    public int sizeX() {
        return this.xSize;
    }

    @Override
    public int sizeY() {
        return this.ySize;
    }

    @NotNull
    public SmallTwoDimensionalFloatArray copy() {
        return new SmallTwoDimensionalFloatArray(this);
    }

    @NotNull
    public static SmallTwoDimensionalFloatArray unitySquare(int n) {
        SmallTwoDimensionalFloatArray smallTwoDimensionalFloatArray = new SmallTwoDimensionalFloatArray(n, n);
        for (int i = 0; i < n; ++i) {
            smallTwoDimensionalFloatArray.setValueAt(1.0f, i, i);
        }
        return smallTwoDimensionalFloatArray;
    }
}

