/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToDoubleFunction2;
import de.caff.generics.mda.TwoDimensionalDoubleAccess;
import de.caff.generics.mda.TwoDimensionalDoubleReadAccess;

public class SmallTwoDimensionalDoubleArray
extends TwoDimensionalDoubleReadAccess.Base
implements TwoDimensionalDoubleAccess {
    @NotNull
    private final double[] values;
    private final int xSize;
    private final int ySize;

    public SmallTwoDimensionalDoubleArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Sizes have to be non-negative!");
        }
        if (Integer.MAX_VALUE / n < n2) {
            throw new IllegalArgumentException("Sizes overflow the range of integer. Use TwoDimensionalDoubleArray instead!");
        }
        this.values = new double[n * n2];
        this.xSize = n;
        this.ySize = n2;
    }

    public SmallTwoDimensionalDoubleArray(int n, int n2, @NotNull IntToDoubleFunction2 intToDoubleFunction2) {
        this(n, n2);
        this.fillValuesByIndex(intToDoubleFunction2);
    }

    public SmallTwoDimensionalDoubleArray(int n, double ... dArray) {
        if (n <= 0 || dArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (dArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = (double[])dArray.clone();
        this.xSize = dArray.length / n;
        this.ySize = n;
    }

    public SmallTwoDimensionalDoubleArray(@NotNull TwoDimensionalDoubleReadAccess twoDimensionalDoubleReadAccess) {
        this(twoDimensionalDoubleReadAccess.sizeX(), twoDimensionalDoubleReadAccess.sizeY(), twoDimensionalDoubleReadAccess::getValueAt);
    }

    private SmallTwoDimensionalDoubleArray(@NotNull SmallTwoDimensionalDoubleArray smallTwoDimensionalDoubleArray) {
        this.values = (double[])smallTwoDimensionalDoubleArray.values.clone();
        this.xSize = smallTwoDimensionalDoubleArray.xSize;
        this.ySize = smallTwoDimensionalDoubleArray.ySize;
    }

    public void invertX() {
        double[] dArray = new double[this.ySize];
        for (int i = 0; i < this.xSize / 2; ++i) {
            int n = i * this.ySize;
            int n2 = (this.xSize - i - 1) * this.ySize;
            System.arraycopy(this.values, n, dArray, 0, this.ySize);
            System.arraycopy(this.values, n2, this.values, n, this.ySize);
            System.arraycopy(dArray, 0, this.values, n2, this.ySize);
        }
    }

    public void invertY() {
        for (int i = 0; i < this.xSize; ++i) {
            int n = i * this.ySize;
            for (int j = 0; j < this.ySize / 2; ++j) {
                int n2 = n + j;
                int n3 = n + this.ySize - j - 1;
                double d = this.values[n2];
                this.values[n2] = this.values[n3];
                this.values[n3] = d;
            }
        }
    }

    private void checkIndices(int n, int n2) {
        if (n >= this.xSize || n < 0) {
            throw new IndexOutOfBoundsException(String.format("ix (%d) is out of range [0, %d[!", n, this.xSize));
        }
        if (n2 >= this.ySize || n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("iy (%d) is out of range [0, %d[!", n2, this.ySize));
        }
    }

    @Override
    public void setValueAt(double d, int n, int n2) {
        this.checkIndices(n, n2);
        this.values[n * this.ySize + n2] = d;
    }

    @Override
    public double getValueAt(int n, int n2) {
        this.checkIndices(n, n2);
        return this.values[n * this.ySize + n2];
    }

    @Override
    public int sizeX() {
        return this.xSize;
    }

    @Override
    public int sizeY() {
        return this.ySize;
    }

    @NotNull
    public SmallTwoDimensionalDoubleArray copy() {
        return new SmallTwoDimensionalDoubleArray(this);
    }

    @NotNull
    public static SmallTwoDimensionalDoubleArray unitySquare(int n) {
        SmallTwoDimensionalDoubleArray smallTwoDimensionalDoubleArray = new SmallTwoDimensionalDoubleArray(n, n);
        for (int i = 0; i < n; ++i) {
            smallTwoDimensionalDoubleArray.setValueAt(1.0, i, i);
        }
        return smallTwoDimensionalDoubleArray;
    }
}

