/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToCharFunction2;
import de.caff.generics.mda.TwoDimensionalCharAccess;
import de.caff.generics.mda.TwoDimensionalCharReadAccess;

public class SmallTwoDimensionalCharArray
extends TwoDimensionalCharReadAccess.Base
implements TwoDimensionalCharAccess {
    @NotNull
    private final char[] values;
    private final int xSize;
    private final int ySize;

    public SmallTwoDimensionalCharArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Sizes have to be non-negative!");
        }
        if (Integer.MAX_VALUE / n < n2) {
            throw new IllegalArgumentException("Sizes overflow the range of integer. Use TwoDimensionalCharArray instead!");
        }
        this.values = new char[n * n2];
        this.xSize = n;
        this.ySize = n2;
    }

    public SmallTwoDimensionalCharArray(int n, int n2, @NotNull IntToCharFunction2 intToCharFunction2) {
        this(n, n2);
        this.fillValuesByIndex(intToCharFunction2);
    }

    public SmallTwoDimensionalCharArray(int n, char ... cArray) {
        if (n <= 0 || cArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (cArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = (char[])cArray.clone();
        this.xSize = cArray.length / n;
        this.ySize = n;
    }

    public SmallTwoDimensionalCharArray(@NotNull TwoDimensionalCharReadAccess twoDimensionalCharReadAccess) {
        this(twoDimensionalCharReadAccess.sizeX(), twoDimensionalCharReadAccess.sizeY(), twoDimensionalCharReadAccess::getValueAt);
    }

    private SmallTwoDimensionalCharArray(@NotNull SmallTwoDimensionalCharArray smallTwoDimensionalCharArray) {
        this.values = (char[])smallTwoDimensionalCharArray.values.clone();
        this.xSize = smallTwoDimensionalCharArray.xSize;
        this.ySize = smallTwoDimensionalCharArray.ySize;
    }

    public void invertX() {
        char[] cArray = new char[this.ySize];
        for (int i = 0; i < this.xSize / 2; ++i) {
            int n = i * this.ySize;
            int n2 = (this.xSize - i - 1) * this.ySize;
            System.arraycopy(this.values, n, cArray, 0, this.ySize);
            System.arraycopy(this.values, n2, this.values, n, this.ySize);
            System.arraycopy(cArray, 0, this.values, n2, this.ySize);
        }
    }

    public void invertY() {
        for (int i = 0; i < this.xSize; ++i) {
            int n = i * this.ySize;
            for (int j = 0; j < this.ySize / 2; ++j) {
                int n2 = n + j;
                int n3 = n + this.ySize - j - 1;
                char c = this.values[n2];
                this.values[n2] = this.values[n3];
                this.values[n3] = c;
            }
        }
    }

    private void checkIndices(int n, int n2) {
        if (n >= this.xSize || n < 0) {
            throw new IndexOutOfBoundsException(String.format("ix (%d) is out of range [0, %d[!", n, this.xSize));
        }
        if (n2 >= this.ySize || n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("iy (%d) is out of range [0, %d[!", n2, this.ySize));
        }
    }

    @Override
    public void setValueAt(char c, int n, int n2) {
        this.checkIndices(n, n2);
        this.values[n * this.ySize + n2] = c;
    }

    @Override
    public char getValueAt(int n, int n2) {
        this.checkIndices(n, n2);
        return this.values[n * this.ySize + n2];
    }

    @Override
    public int sizeX() {
        return this.xSize;
    }

    @Override
    public int sizeY() {
        return this.ySize;
    }

    @NotNull
    public SmallTwoDimensionalCharArray copy() {
        return new SmallTwoDimensionalCharArray(this);
    }
}

