/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntToByteFunction2;
import de.caff.generics.mda.TwoDimensionalByteAccess;
import de.caff.generics.mda.TwoDimensionalByteReadAccess;

public class SmallTwoDimensionalByteArray
extends TwoDimensionalByteReadAccess.Base
implements TwoDimensionalByteAccess {
    @NotNull
    private final byte[] values;
    private final int xSize;
    private final int ySize;

    public SmallTwoDimensionalByteArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Sizes have to be non-negative!");
        }
        if (Integer.MAX_VALUE / n < n2) {
            throw new IllegalArgumentException("Sizes overflow the range of integer. Use TwoDimensionalByteArray instead!");
        }
        this.values = new byte[n * n2];
        this.xSize = n;
        this.ySize = n2;
    }

    public SmallTwoDimensionalByteArray(int n, int n2, @NotNull IntToByteFunction2 intToByteFunction2) {
        this(n, n2);
        this.fillValuesByIndex(intToByteFunction2);
    }

    public SmallTwoDimensionalByteArray(int n, byte ... byArray) {
        if (n <= 0 || byArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (byArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = (byte[])byArray.clone();
        this.xSize = byArray.length / n;
        this.ySize = n;
    }

    public SmallTwoDimensionalByteArray(@NotNull TwoDimensionalByteReadAccess twoDimensionalByteReadAccess) {
        this(twoDimensionalByteReadAccess.sizeX(), twoDimensionalByteReadAccess.sizeY(), twoDimensionalByteReadAccess::getValueAt);
    }

    private SmallTwoDimensionalByteArray(@NotNull SmallTwoDimensionalByteArray smallTwoDimensionalByteArray) {
        this.values = (byte[])smallTwoDimensionalByteArray.values.clone();
        this.xSize = smallTwoDimensionalByteArray.xSize;
        this.ySize = smallTwoDimensionalByteArray.ySize;
    }

    public void invertX() {
        byte[] byArray = new byte[this.ySize];
        for (int i = 0; i < this.xSize / 2; ++i) {
            int n = i * this.ySize;
            int n2 = (this.xSize - i - 1) * this.ySize;
            System.arraycopy(this.values, n, byArray, 0, this.ySize);
            System.arraycopy(this.values, n2, this.values, n, this.ySize);
            System.arraycopy(byArray, 0, this.values, n2, this.ySize);
        }
    }

    public void invertY() {
        for (int i = 0; i < this.xSize; ++i) {
            int n = i * this.ySize;
            for (int j = 0; j < this.ySize / 2; ++j) {
                int n2 = n + j;
                int n3 = n + this.ySize - j - 1;
                byte by = this.values[n2];
                this.values[n2] = this.values[n3];
                this.values[n3] = by;
            }
        }
    }

    private void checkIndices(int n, int n2) {
        if (n >= this.xSize || n < 0) {
            throw new IndexOutOfBoundsException(String.format("ix (%d) is out of range [0, %d[!", n, this.xSize));
        }
        if (n2 >= this.ySize || n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("iy (%d) is out of range [0, %d[!", n2, this.ySize));
        }
    }

    @Override
    public void setValueAt(byte by, int n, int n2) {
        this.checkIndices(n, n2);
        this.values[n * this.ySize + n2] = by;
    }

    @Override
    public byte getValueAt(int n, int n2) {
        this.checkIndices(n, n2);
        return this.values[n * this.ySize + n2];
    }

    @Override
    public int sizeX() {
        return this.xSize;
    }

    @Override
    public int sizeY() {
        return this.ySize;
    }

    @NotNull
    public SmallTwoDimensionalByteArray copy() {
        return new SmallTwoDimensionalByteArray(this);
    }
}

