/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntPredicate2;
import de.caff.generics.mda.TwoDimensionalBooleanAccess;
import de.caff.generics.mda.TwoDimensionalBooleanReadAccess;

public class SmallTwoDimensionalBooleanArray
extends TwoDimensionalBooleanReadAccess.Base
implements TwoDimensionalBooleanAccess {
    @NotNull
    private final boolean[] values;
    private final int xSize;
    private final int ySize;

    public SmallTwoDimensionalBooleanArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Sizes have to be non-negative!");
        }
        if (Integer.MAX_VALUE / n < n2) {
            throw new IllegalArgumentException("Sizes overflow the range of integer. Use TwoDimensionalBooleanArray instead!");
        }
        this.values = new boolean[n * n2];
        this.xSize = n;
        this.ySize = n2;
    }

    public SmallTwoDimensionalBooleanArray(int n, int n2, @NotNull IntPredicate2 intPredicate2) {
        this(n, n2);
        this.fillValuesByIndex(intPredicate2);
    }

    public SmallTwoDimensionalBooleanArray(int n, boolean ... blArray) {
        if (n <= 0 || blArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (blArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = (boolean[])blArray.clone();
        this.xSize = blArray.length / n;
        this.ySize = n;
    }

    public SmallTwoDimensionalBooleanArray(@NotNull TwoDimensionalBooleanReadAccess twoDimensionalBooleanReadAccess) {
        this(twoDimensionalBooleanReadAccess.sizeX(), twoDimensionalBooleanReadAccess.sizeY(), twoDimensionalBooleanReadAccess::getValueAt);
    }

    private SmallTwoDimensionalBooleanArray(@NotNull SmallTwoDimensionalBooleanArray smallTwoDimensionalBooleanArray) {
        this.values = (boolean[])smallTwoDimensionalBooleanArray.values.clone();
        this.xSize = smallTwoDimensionalBooleanArray.xSize;
        this.ySize = smallTwoDimensionalBooleanArray.ySize;
    }

    public void invertX() {
        boolean[] blArray = new boolean[this.ySize];
        for (int i = 0; i < this.xSize / 2; ++i) {
            int n = i * this.ySize;
            int n2 = (this.xSize - i - 1) * this.ySize;
            System.arraycopy(this.values, n, blArray, 0, this.ySize);
            System.arraycopy(this.values, n2, this.values, n, this.ySize);
            System.arraycopy(blArray, 0, this.values, n2, this.ySize);
        }
    }

    public void invertY() {
        for (int i = 0; i < this.xSize; ++i) {
            int n = i * this.ySize;
            for (int j = 0; j < this.ySize / 2; ++j) {
                int n2 = n + j;
                int n3 = n + this.ySize - j - 1;
                boolean bl = this.values[n2];
                this.values[n2] = this.values[n3];
                this.values[n3] = bl;
            }
        }
    }

    private void checkIndices(int n, int n2) {
        if (n >= this.xSize || n < 0) {
            throw new IndexOutOfBoundsException(String.format("ix (%d) is out of range [0, %d[!", n, this.xSize));
        }
        if (n2 >= this.ySize || n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("iy (%d) is out of range [0, %d[!", n2, this.ySize));
        }
    }

    @Override
    public void setValueAt(boolean bl, int n, int n2) {
        this.checkIndices(n, n2);
        this.values[n * this.ySize + n2] = bl;
    }

    @Override
    public boolean getValueAt(int n, int n2) {
        this.checkIndices(n, n2);
        return this.values[n * this.ySize + n2];
    }

    @Override
    public int sizeX() {
        return this.xSize;
    }

    @Override
    public int sizeY() {
        return this.ySize;
    }

    @NotNull
    public SmallTwoDimensionalBooleanArray copy() {
        return new SmallTwoDimensionalBooleanArray(this);
    }
}

