/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntPredicate2;
import de.caff.generics.mda.TwoDimensionalBooleanAccess;
import de.caff.generics.mda.TwoDimensionalBooleanReadAccess;

public class SmallTwoDimensionalBitArray
extends TwoDimensionalBooleanReadAccess.Base
implements TwoDimensionalBooleanAccess {
    @NotNull
    private final long[] values;
    private final int xSize;
    private final int ySize;

    public SmallTwoDimensionalBitArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Sizes have to be non-negative!");
        }
        long l = (long)n * (long)n2;
        long l2 = l % 64L;
        if (l2 != 0L) {
            l += 64L - l2;
        }
        if (l / 64L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sizes overflow the range of integer. Use TwoDimensionalBooleanArray instead!");
        }
        this.values = new long[(int)(l / 64L)];
        this.xSize = n;
        this.ySize = n2;
    }

    public SmallTwoDimensionalBitArray(int n, int n2, @NotNull IntPredicate2 intPredicate2) {
        this(n, n2);
        this.fillValuesByIndex(intPredicate2);
    }

    public SmallTwoDimensionalBitArray(int n, boolean ... blArray) {
        if (n <= 0 || blArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (blArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        long l = blArray.length;
        long l2 = l % 64L;
        if (l2 != 0L) {
            l += 64L - l2;
        }
        this.values = new long[(int)(l / 64L)];
        this.xSize = blArray.length / n;
        this.ySize = n;
        this.fillByIndex((n2, n3) -> blArray[n2 * n + n3]);
    }

    public SmallTwoDimensionalBitArray(@NotNull TwoDimensionalBooleanReadAccess twoDimensionalBooleanReadAccess) {
        this(twoDimensionalBooleanReadAccess.sizeX(), twoDimensionalBooleanReadAccess.sizeY(), twoDimensionalBooleanReadAccess::getValueAt);
    }

    private SmallTwoDimensionalBitArray(@NotNull SmallTwoDimensionalBitArray smallTwoDimensionalBitArray) {
        this.values = (long[])smallTwoDimensionalBitArray.values.clone();
        this.xSize = smallTwoDimensionalBitArray.xSize;
        this.ySize = smallTwoDimensionalBitArray.ySize;
    }

    private void checkIndices(int n, int n2) {
        if (n >= this.xSize || n < 0) {
            throw new IndexOutOfBoundsException(String.format("ix (%d) is out of range [0, %d[!", n, this.xSize));
        }
        if (n2 >= this.ySize || n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("iy (%d) is out of range [0, %d[!", n2, this.ySize));
        }
    }

    @Override
    public void setValueAt(boolean bl, int n, int n2) {
        this.checkIndices(n, n2);
        long l = (long)n * (long)this.ySize + (long)n2;
        int n3 = (int)(l / 64L);
        int n4 = (int)(l % 64L);
        int n5 = n3;
        this.values[n5] = this.values[n5] | 1L << n4;
    }

    @Override
    public boolean getValueAt(int n, int n2) {
        this.checkIndices(n, n2);
        long l = (long)n * (long)this.ySize + (long)n2;
        int n3 = (int)(l / 64L);
        int n4 = (int)(l % 64L);
        return (this.values[n3] | 1L << n4) != 0L;
    }

    @Override
    public int sizeX() {
        return this.xSize;
    }

    @Override
    public int sizeY() {
        return this.ySize;
    }

    @NotNull
    public SmallTwoDimensionalBitArray copy() {
        return new SmallTwoDimensionalBitArray(this);
    }
}

