/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.IntFunction2;
import de.caff.generics.mda.TwoDimensionalAccess;
import de.caff.generics.mda.TwoDimensionalReadAccess;

public class SmallTwoDimensionalArray<T>
extends TwoDimensionalReadAccess.Base<T>
implements TwoDimensionalAccess<T> {
    @NotNull
    private final T[] values;
    private final int xSize;
    private final int ySize;

    public SmallTwoDimensionalArray(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Sizes have to be non-negative!");
        }
        if (Integer.MAX_VALUE / n < n2) {
            throw new IllegalArgumentException("Sizes overflow the range of integer. Use TwoDimensionalDoubleArray instead!");
        }
        this.values = new Object[n * n2];
        this.xSize = n;
        this.ySize = n2;
    }

    public SmallTwoDimensionalArray(int n, int n2, @NotNull IntFunction2<T> intFunction2) {
        this(n, n2);
        this.fillByIndex(intFunction2);
    }

    @SafeVarargs
    public SmallTwoDimensionalArray(int n, T ... TArray) {
        if (n <= 0 || TArray.length == 0) {
            throw new IllegalArgumentException("Need positive sizes!");
        }
        if (TArray.length % n != 0) {
            throw new IllegalArgumentException("Need a multiple of ySize values!");
        }
        this.values = (Object[])TArray.clone();
        this.xSize = TArray.length / n;
        this.ySize = n;
    }

    public SmallTwoDimensionalArray(@NotNull TwoDimensionalReadAccess<? extends T> twoDimensionalReadAccess) {
        this(twoDimensionalReadAccess.sizeX(), twoDimensionalReadAccess.sizeY(), twoDimensionalReadAccess::getElementAt);
    }

    private SmallTwoDimensionalArray(@NotNull SmallTwoDimensionalArray<? extends T> smallTwoDimensionalArray) {
        this.values = (Object[])smallTwoDimensionalArray.values.clone();
        this.xSize = smallTwoDimensionalArray.xSize;
        this.ySize = smallTwoDimensionalArray.ySize;
    }

    public void invertX() {
        double[] dArray = new double[this.ySize];
        for (int i = 0; i < this.xSize / 2; ++i) {
            int n = i * this.ySize;
            int n2 = (this.xSize - i - 1) * this.ySize;
            System.arraycopy(this.values, n, dArray, 0, this.ySize);
            System.arraycopy(this.values, n2, this.values, n, this.ySize);
            System.arraycopy(dArray, 0, this.values, n2, this.ySize);
        }
    }

    public void invertY() {
        for (int i = 0; i < this.xSize; ++i) {
            int n = i * this.ySize;
            for (int j = 0; j < this.ySize / 2; ++j) {
                int n2 = n + j;
                int n3 = n + this.ySize - j - 1;
                T t = this.values[n2];
                this.values[n2] = this.values[n3];
                this.values[n3] = t;
            }
        }
    }

    private void checkIndices(int n, int n2) {
        if (n >= this.xSize || n < 0) {
            throw new IndexOutOfBoundsException(String.format("ix (%d) is out of range [0, %d[!", n, this.xSize));
        }
        if (n2 >= this.ySize || n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("iy (%d) is out of range [0, %d[!", n2, this.ySize));
        }
    }

    @Override
    public void setElementAt(T t, int n, int n2) {
        this.checkIndices(n, n2);
        this.values[n * this.ySize + n2] = t;
    }

    @Override
    public T getElementAt(int n, int n2) {
        this.checkIndices(n, n2);
        return this.values[n * this.ySize + n2];
    }

    @Override
    public int sizeX() {
        return this.xSize;
    }

    @Override
    public int sizeY() {
        return this.ySize;
    }

    @NotNull
    public SmallTwoDimensionalArray<T> copy() {
        return new SmallTwoDimensionalArray<T>(this);
    }
}

