/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.mda.MultiIndexLinearizer;
import java.util.Arrays;

class PartlyFixedMultiIndexLinearizer
implements MultiIndexLinearizer {
    @NotNull
    private final MultiIndexLinearizer basicLinearizer;
    @NotNull
    private final int[] fixedIndexes;
    private final int[] mapping;
    private final int numElements;

    PartlyFixedMultiIndexLinearizer(@NotNull MultiIndexLinearizer multiIndexLinearizer, int ... nArray) {
        if (nArray.length > multiIndexLinearizer.getNumDimensions()) {
            throw new IllegalArgumentException("Too many fixed values for the given linearizer!");
        }
        this.basicLinearizer = multiIndexLinearizer;
        this.fixedIndexes = new int[multiIndexLinearizer.getNumDimensions()];
        Arrays.fill(this.fixedIndexes, -1);
        System.arraycopy(nArray, 0, this.fixedIndexes, 0, nArray.length);
        int n = 0;
        int n2 = 1;
        int[] nArray2 = new int[this.fixedIndexes.length];
        for (int i = 0; i < this.fixedIndexes.length; ++i) {
            int n3 = this.fixedIndexes[i];
            int n4 = multiIndexLinearizer.getSize(i);
            if (n3 < 0) {
                nArray2[n++] = i;
                n2 *= n4;
                continue;
            }
            if (n3 < n4) continue;
            throw new IllegalArgumentException(String.format("Fixed index %d is too large for %d elements!", n3, n4));
        }
        this.mapping = Arrays.copyOf(nArray2, n);
        this.numElements = n2;
    }

    @Override
    public int getNumDimensions() {
        return this.mapping.length;
    }

    @Override
    public int getSize(int n) {
        return this.basicLinearizer.getSize(this.mapping[n]);
    }

    @Override
    @NotNull
    public int[] getSizes() {
        int[] nArray = new int[this.mapping.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getSize(i);
        }
        return nArray;
    }

    @Override
    public int toLinear(int ... nArray) {
        if (nArray.length != this.getNumDimensions()) {
            throw new IllegalArgumentException(String.format("Incorrect number of indexes for an array with %d dimensions: %d!", this.mapping.length, nArray.length));
        }
        int[] nArray2 = new int[this.fixedIndexes.length];
        int n = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            int n2 = this.fixedIndexes[i];
            nArray2[i] = n2 >= 0 ? n2 : nArray[n++];
        }
        return this.basicLinearizer.toLinear(nArray2);
    }

    @Override
    public long getNumElements() {
        return this.numElements;
    }
}

