/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.Indexable;
import de.caff.generics.ShortIndexable;
import de.caff.generics.function.IntToShortFunction1;
import de.caff.generics.mda.MultiDimensionalShortArray;
import de.caff.generics.mda.OneDimensionalShortAccess;
import de.caff.generics.mda.OneDimensionalShortReadAccess;
import java.util.Collection;

public class OneDimensionalShortArray
extends OneDimensionalShortReadAccess.Base
implements OneDimensionalShortAccess {
    @NotNull
    private final short[] values;

    public OneDimensionalShortArray(short ... sArray) {
        this.values = (short[])sArray.clone();
    }

    public OneDimensionalShortArray(int n) {
        this.values = new short[n];
    }

    public OneDimensionalShortArray(int n, @NotNull IntToShortFunction1 intToShortFunction1) {
        this(n);
        this.fillValuesByIndex(intToShortFunction1);
    }

    public OneDimensionalShortArray(@NotNull Indexable<Short> indexable) {
        this(indexable.size(), indexable::get);
    }

    public OneDimensionalShortArray(@NotNull ShortIndexable shortIndexable) {
        this(shortIndexable.size(), shortIndexable::get);
    }

    public OneDimensionalShortArray(@NotNull Collection<Short> collection) {
        this(collection.size());
        int n = 0;
        for (Short s : collection) {
            this.values[n++] = s;
        }
    }

    public OneDimensionalShortArray(@NotNull OneDimensionalShortArray oneDimensionalShortArray) {
        this(oneDimensionalShortArray.values);
    }

    public OneDimensionalShortArray(@NotNull MultiDimensionalShortArray multiDimensionalShortArray) {
        if (multiDimensionalShortArray.getNumDimensions() != 1) {
            throw new IllegalArgumentException("Cannot only copy from 1-dimensional arrays!");
        }
        this.values = new short[multiDimensionalShortArray.getSize(0)];
        for (int i = this.values.length - 1; i >= 0; --i) {
            this.values[i] = multiDimensionalShortArray.getValue(i);
        }
    }

    @Override
    public void setValueAt(short s, int n) {
        this.values[n] = s;
    }

    @Override
    public short getValueAt(int n) {
        return this.values[n];
    }

    @Override
    public int size() {
        return this.values.length;
    }
}

