/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.Indexable;
import de.caff.generics.function.Function1;
import de.caff.generics.function.Procedure1;
import de.caff.generics.function.Procedure2;
import de.caff.generics.mda.MultiDimensionalReadAccess;
import de.caff.generics.mda.OneDimensionalArray;

public interface OneDimensionalReadAccess<T>
extends Indexable<T>,
MultiDimensionalReadAccess<T> {
    public static final OneDimensionalReadAccess<?> EMPTY = new Base<Object>(){

        @Override
        public Object get(int n) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    @Override
    default public T getElement(int ... nArray) {
        if (nArray.length != 1) {
            throw new IllegalArgumentException("Invalid number of indexes for 1-dimensional array: " + nArray.length);
        }
        return this.get(nArray[0]);
    }

    @Override
    default public int getNumDimensions() {
        return 1;
    }

    @Override
    default public int getSize(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("Invalid dimension for 1-dimensional array: " + n);
        }
        return this.size();
    }

    @Override
    @NotNull
    default public int[] getSizes() {
        return new int[]{this.size()};
    }

    @Override
    default public long getNumElements() {
        return this.size();
    }

    @NotNull
    default public OneDimensionalReadAccess<T> copy() {
        return new OneDimensionalArray(this);
    }

    @Override
    @NotNull
    default public <TOUT> OneDimensionalReadAccess<TOUT> view(final @NotNull Function1<TOUT, ? super T> function1) {
        return new OneDimensionalReadAccess<TOUT>(){

            @Override
            public int size() {
                return OneDimensionalReadAccess.this.size();
            }

            @Override
            public TOUT get(int n) {
                return function1.apply(OneDimensionalReadAccess.this.get(n));
            }
        };
    }

    @Override
    default public void visitAll(@NotNull Procedure2<? super T, int[]> procedure2) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            procedure2.apply(this.get(i), new int[]{i});
        }
    }

    @Override
    default public void visitAll(@NotNull Procedure1<? super T> procedure1) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            procedure1.apply(this.get(i));
        }
    }

    @Override
    @NotNull
    default public Base<T> asBase() {
        return new Base<T>(){

            @Override
            public int size() {
                return OneDimensionalReadAccess.this.size();
            }

            @Override
            public T get(int n) {
                return OneDimensionalReadAccess.this.get(n);
            }
        };
    }

    @NotNull
    public static <E> OneDimensionalReadAccess<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> OneDimensionalReadAccess<E> singleton(final E e) {
        return new OneDimensionalReadAccess<E>(){

            @Override
            public E get(int n) {
                if (n != 0) {
                    throw new IndexOutOfBoundsException();
                }
                return e;
            }

            @Override
            public int size() {
                return 1;
            }
        };
    }

    public static abstract class Base<TT>
    extends Indexable.Base<TT>
    implements OneDimensionalReadAccess<TT> {
        @Override
        @NotNull
        public Base<TT> asBase() {
            return this;
        }
    }
}

