/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.Indexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.mda.MultiDimensionalLongArray;
import de.caff.generics.mda.OneDimensionalLongAccess;
import de.caff.generics.mda.OneDimensionalLongReadAccess;
import java.util.Collection;
import java.util.function.IntToLongFunction;

public class OneDimensionalLongArray
extends OneDimensionalLongReadAccess.Base
implements OneDimensionalLongAccess {
    @NotNull
    private final long[] values;

    public OneDimensionalLongArray(long ... lArray) {
        this.values = (long[])lArray.clone();
    }

    public OneDimensionalLongArray(int n) {
        this.values = new long[n];
    }

    public OneDimensionalLongArray(int n, @NotNull IntToLongFunction intToLongFunction) {
        this(n);
        this.fillValuesByIndex(intToLongFunction);
    }

    public OneDimensionalLongArray(@NotNull Indexable<Long> indexable) {
        this(indexable.size(), indexable::get);
    }

    public OneDimensionalLongArray(@NotNull LongIndexable longIndexable) {
        this(longIndexable.size(), longIndexable::get);
    }

    public OneDimensionalLongArray(@NotNull Collection<Long> collection) {
        this(collection.size());
        int n = 0;
        for (Long l : collection) {
            this.values[n++] = l;
        }
    }

    public OneDimensionalLongArray(@NotNull OneDimensionalLongArray oneDimensionalLongArray) {
        this(oneDimensionalLongArray.values);
    }

    public OneDimensionalLongArray(@NotNull MultiDimensionalLongArray multiDimensionalLongArray) {
        if (multiDimensionalLongArray.getNumDimensions() != 1) {
            throw new IllegalArgumentException("Cannot only copy from 1-dimensional arrays!");
        }
        this.values = new long[multiDimensionalLongArray.getSize(0)];
        for (int i = this.values.length - 1; i >= 0; --i) {
            this.values[i] = multiDimensionalLongArray.getValueAt(i);
        }
    }

    @Override
    public void setValueAt(long l, int n) {
        this.values[n] = l;
    }

    @Override
    public long getValueAt(int n) {
        return this.values[n];
    }

    @Override
    public int size() {
        return this.values.length;
    }
}

