/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.mda.MultiDimensionalIntArray;
import de.caff.generics.mda.OneDimensionalIntAccess;
import de.caff.generics.mda.OneDimensionalIntReadAccess;
import java.util.Collection;
import java.util.function.IntUnaryOperator;

public class OneDimensionalIntArray
extends OneDimensionalIntReadAccess.Base
implements OneDimensionalIntAccess {
    @NotNull
    private final int[] values;

    public OneDimensionalIntArray(int ... nArray) {
        this.values = (int[])nArray.clone();
    }

    public OneDimensionalIntArray(int n) {
        this.values = new int[n];
    }

    public OneDimensionalIntArray(int n, @NotNull IntUnaryOperator intUnaryOperator) {
        this(n);
        this.fillValuesByIndex(intUnaryOperator);
    }

    public OneDimensionalIntArray(@NotNull Indexable<Integer> indexable) {
        this(indexable.size(), indexable::get);
    }

    public OneDimensionalIntArray(@NotNull IntIndexable intIndexable) {
        this(intIndexable.size(), intIndexable::get);
    }

    public OneDimensionalIntArray(@NotNull Collection<? extends Integer> collection) {
        this(collection.size());
        int n = 0;
        for (Integer n2 : collection) {
            this.values[n++] = n2;
        }
    }

    public OneDimensionalIntArray(@NotNull OneDimensionalIntArray oneDimensionalIntArray) {
        this(oneDimensionalIntArray.values);
    }

    public OneDimensionalIntArray(@NotNull MultiDimensionalIntArray multiDimensionalIntArray) {
        if (multiDimensionalIntArray.getNumDimensions() != 1) {
            throw new IllegalArgumentException("Cannot only copy from 1-dimensional arrays!");
        }
        this.values = new int[multiDimensionalIntArray.getSize(0)];
        for (int i = this.values.length - 1; i >= 0; --i) {
            this.values[i] = multiDimensionalIntArray.getValue(i);
        }
    }

    @Override
    public void setValueAt(int n, int n2) {
        this.values[n2] = n;
    }

    @Override
    public int getValueAt(int n) {
        return this.values[n];
    }

    @Override
    public int size() {
        return this.values.length;
    }
}

