/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.function.IntToFloatFunction1;
import de.caff.generics.mda.MultiDimensionalFloatArray;
import de.caff.generics.mda.OneDimensionalFloatAccess;
import de.caff.generics.mda.OneDimensionalFloatReadAccess;
import java.util.Collection;

public class OneDimensionalFloatArray
extends OneDimensionalFloatReadAccess.Base
implements OneDimensionalFloatAccess {
    @NotNull
    private final float[] values;

    public OneDimensionalFloatArray(float ... fArray) {
        this.values = (float[])fArray.clone();
    }

    public OneDimensionalFloatArray(int n) {
        this.values = new float[n];
    }

    public OneDimensionalFloatArray(int n, @NotNull IntToFloatFunction1 intToFloatFunction1) {
        this(n);
        this.fillValuesByIndex(intToFloatFunction1);
    }

    public OneDimensionalFloatArray(@NotNull Indexable<Float> indexable) {
        this(indexable.size(), indexable::get);
    }

    public OneDimensionalFloatArray(@NotNull FloatIndexable floatIndexable) {
        this(floatIndexable.size(), floatIndexable::get);
    }

    public OneDimensionalFloatArray(@NotNull Collection<Float> collection) {
        this(collection.size());
        int n = 0;
        for (Float f : collection) {
            this.values[n++] = f.floatValue();
        }
    }

    public OneDimensionalFloatArray(@NotNull OneDimensionalFloatArray oneDimensionalFloatArray) {
        this(oneDimensionalFloatArray.values);
    }

    public OneDimensionalFloatArray(@NotNull MultiDimensionalFloatArray multiDimensionalFloatArray) {
        if (multiDimensionalFloatArray.getNumDimensions() != 1) {
            throw new IllegalArgumentException("Cannot only copy from 1-dimensional arrays!");
        }
        this.values = new float[multiDimensionalFloatArray.getSize(0)];
        for (int i = this.values.length - 1; i >= 0; --i) {
            this.values[i] = multiDimensionalFloatArray.getValue(i);
        }
    }

    @Override
    public void setValueAt(float f, int n) {
        this.values[n] = f;
    }

    @Override
    public float getValueAt(int n) {
        return this.values[n];
    }

    @Override
    public int size() {
        return this.values.length;
    }
}

