/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.mda.MultiDimensionalDoubleArray;
import de.caff.generics.mda.OneDimensionalDoubleAccess;
import de.caff.generics.mda.OneDimensionalDoubleReadAccess;
import java.util.Collection;
import java.util.function.IntToDoubleFunction;

public class OneDimensionalDoubleArray
extends OneDimensionalDoubleReadAccess.Base
implements OneDimensionalDoubleAccess {
    @NotNull
    private final double[] values;

    public OneDimensionalDoubleArray(double ... dArray) {
        this.values = (double[])dArray.clone();
    }

    public OneDimensionalDoubleArray(int n) {
        this.values = new double[n];
    }

    public OneDimensionalDoubleArray(int n, @NotNull IntToDoubleFunction intToDoubleFunction) {
        this(n);
        this.fillValuesByIndex(intToDoubleFunction);
    }

    public OneDimensionalDoubleArray(@NotNull Indexable<Double> indexable) {
        this(indexable.size(), indexable::get);
    }

    public OneDimensionalDoubleArray(@NotNull DoubleIndexable doubleIndexable) {
        this(doubleIndexable.size(), doubleIndexable::get);
    }

    public OneDimensionalDoubleArray(@NotNull Collection<Double> collection) {
        this(collection.size());
        int n = 0;
        for (Double d : collection) {
            this.values[n++] = d;
        }
    }

    public OneDimensionalDoubleArray(@NotNull OneDimensionalDoubleArray oneDimensionalDoubleArray) {
        this(oneDimensionalDoubleArray.values);
    }

    public OneDimensionalDoubleArray(@NotNull MultiDimensionalDoubleArray multiDimensionalDoubleArray) {
        if (multiDimensionalDoubleArray.getNumDimensions() != 1) {
            throw new IllegalArgumentException("Cannot only copy from 1-dimensional arrays!");
        }
        this.values = new double[multiDimensionalDoubleArray.getSize(0)];
        for (int i = this.values.length - 1; i >= 0; --i) {
            this.values[i] = multiDimensionalDoubleArray.getValue(i);
        }
    }

    @Override
    public void setValueAt(double d, int n) {
        this.values[n] = d;
    }

    @Override
    public double getValueAt(int n) {
        return this.values[n];
    }

    @Override
    public int size() {
        return this.values.length;
    }
}

