/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.mda.OneDimensionalAccess;
import de.caff.generics.mda.OneDimensionalDoubleReadAccess;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;

public interface OneDimensionalDoubleAccess
extends OneDimensionalDoubleReadAccess,
OneDimensionalAccess<Double> {
    public static final OneDimensionalDoubleAccess EMPTY = new OneDimensionalDoubleAccess(){

        @Override
        public void setValueAt(double d, int n) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public double getValueAt(int n) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    public void setValueAt(double var1, int var3);

    default public void changeValueAt(@NotNull DoubleUnaryOperator doubleUnaryOperator, int n) {
        this.setValueAt(doubleUnaryOperator.applyAsDouble(this.getValueAt(n)), n);
    }

    default public void changeAllValues(@NotNull DoubleUnaryOperator doubleUnaryOperator) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.changeValueAt(doubleUnaryOperator, i);
        }
    }

    default public void fillValuesByIndex(@NotNull IntToDoubleFunction intToDoubleFunction) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setValueAt(intToDoubleFunction.applyAsDouble(i), i);
        }
    }

    @Override
    default public void set(int n, @NotNull Double d) {
        this.setValueAt(d, n);
    }
}

