/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.CharIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.function.IntToCharFunction1;
import de.caff.generics.mda.MultiDimensionalCharArray;
import de.caff.generics.mda.OneDimensionalCharAccess;
import de.caff.generics.mda.OneDimensionalCharReadAccess;
import java.util.Collection;

public class OneDimensionalCharArray
extends OneDimensionalCharReadAccess.Base
implements OneDimensionalCharAccess {
    @NotNull
    private final char[] values;

    public OneDimensionalCharArray(char ... cArray) {
        this.values = (char[])cArray.clone();
    }

    public OneDimensionalCharArray(int n) {
        this.values = new char[n];
    }

    public OneDimensionalCharArray(int n, @NotNull IntToCharFunction1 intToCharFunction1) {
        this(n);
        this.fillValuesByIndex(intToCharFunction1);
    }

    public OneDimensionalCharArray(@NotNull Indexable<Character> indexable) {
        this(indexable.size(), indexable::get);
    }

    public OneDimensionalCharArray(@NotNull CharIndexable charIndexable) {
        this(charIndexable.size(), charIndexable::get);
    }

    public OneDimensionalCharArray(@NotNull Collection<Character> collection) {
        this(collection.size());
        int n = 0;
        for (Character c : collection) {
            this.values[n++] = c.charValue();
        }
    }

    public OneDimensionalCharArray(@NotNull OneDimensionalCharArray oneDimensionalCharArray) {
        this(oneDimensionalCharArray.values);
    }

    public OneDimensionalCharArray(@NotNull MultiDimensionalCharArray multiDimensionalCharArray) {
        if (multiDimensionalCharArray.getNumDimensions() != 1) {
            throw new IllegalArgumentException("Cannot only copy from 1-dimensional arrays!");
        }
        this.values = new char[multiDimensionalCharArray.getSize(0)];
        for (int i = this.values.length - 1; i >= 0; --i) {
            this.values[i] = multiDimensionalCharArray.getValue(i);
        }
    }

    @Override
    public void setValueAt(char c, int n) {
        this.values[n] = c;
    }

    @Override
    public char getValueAt(int n) {
        return this.values[n];
    }

    @Override
    public int size() {
        return this.values.length;
    }
}

