/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.ByteIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.function.IntToByteFunction1;
import de.caff.generics.mda.MultiDimensionalByteArray;
import de.caff.generics.mda.OneDimensionalByteAccess;
import java.util.Collection;

public class OneDimensionalByteArray
implements OneDimensionalByteAccess {
    @NotNull
    private final byte[] values;

    public OneDimensionalByteArray(byte ... byArray) {
        this.values = (byte[])byArray.clone();
    }

    public OneDimensionalByteArray(int n) {
        this.values = new byte[n];
    }

    public OneDimensionalByteArray(int n, @NotNull IntToByteFunction1 intToByteFunction1) {
        this(n);
        this.fillValuesByIndex(intToByteFunction1);
    }

    public OneDimensionalByteArray(@NotNull Indexable<Byte> indexable) {
        this(indexable.size(), indexable::get);
    }

    public OneDimensionalByteArray(@NotNull ByteIndexable byteIndexable) {
        this(byteIndexable.size(), byteIndexable::get);
    }

    public OneDimensionalByteArray(@NotNull Collection<Byte> collection) {
        this(collection.size());
        int n = 0;
        for (Byte by : collection) {
            this.values[n++] = by;
        }
    }

    public OneDimensionalByteArray(@NotNull OneDimensionalByteArray oneDimensionalByteArray) {
        this(oneDimensionalByteArray.values);
    }

    public OneDimensionalByteArray(@NotNull MultiDimensionalByteArray multiDimensionalByteArray) {
        if (multiDimensionalByteArray.getNumDimensions() != 1) {
            throw new IllegalArgumentException("Cannot only copy from 1-dimensional arrays!");
        }
        this.values = new byte[multiDimensionalByteArray.getSize(0)];
        for (int i = this.values.length - 1; i >= 0; --i) {
            this.values[i] = multiDimensionalByteArray.getValue(i);
        }
    }

    @Override
    public void setValueAt(byte by, int n) {
        this.values[n] = by;
    }

    @Override
    public byte getValueAt(int n) {
        return this.values[n];
    }

    @Override
    public int size() {
        return this.values.length;
    }
}

