/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.function.IntPredicate1;
import de.caff.generics.mda.MultiDimensionalBooleanArray;
import de.caff.generics.mda.OneDimensionalBooleanAccess;
import de.caff.generics.mda.OneDimensionalBooleanReadAccess;
import java.util.Collection;

public class OneDimensionalBooleanArray
extends OneDimensionalBooleanReadAccess.Base
implements OneDimensionalBooleanAccess {
    @NotNull
    private final boolean[] values;

    public OneDimensionalBooleanArray(boolean ... blArray) {
        this.values = (boolean[])blArray.clone();
    }

    public OneDimensionalBooleanArray(int n) {
        this.values = new boolean[n];
    }

    public OneDimensionalBooleanArray(int n, @NotNull IntPredicate1 intPredicate1) {
        this(n);
        this.fillValuesByIndex(intPredicate1);
    }

    public OneDimensionalBooleanArray(@NotNull Indexable<Boolean> indexable) {
        this(indexable.size(), indexable::get);
    }

    public OneDimensionalBooleanArray(@NotNull BooleanIndexable booleanIndexable) {
        this(booleanIndexable.size(), booleanIndexable::get);
    }

    public OneDimensionalBooleanArray(@NotNull Collection<Boolean> collection) {
        this(collection.size());
        int n = 0;
        for (Boolean bl : collection) {
            this.values[n++] = bl;
        }
    }

    public OneDimensionalBooleanArray(@NotNull OneDimensionalBooleanArray oneDimensionalBooleanArray) {
        this(oneDimensionalBooleanArray.values);
    }

    public OneDimensionalBooleanArray(@NotNull MultiDimensionalBooleanArray multiDimensionalBooleanArray) {
        if (multiDimensionalBooleanArray.getNumDimensions() != 1) {
            throw new IllegalArgumentException("Cannot only copy from 1-dimensional arrays!");
        }
        this.values = new boolean[multiDimensionalBooleanArray.getSize(0)];
        for (int i = this.values.length - 1; i >= 0; --i) {
            this.values[i] = multiDimensionalBooleanArray.getValue(i);
        }
    }

    @Override
    public void setValueAt(boolean bl, int n) {
        this.values[n] = bl;
    }

    @Override
    public boolean getValueAt(int n) {
        return this.values[n];
    }

    @Override
    public int size() {
        return this.values.length;
    }
}

