/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.Indexable;
import de.caff.generics.Types;
import de.caff.generics.mda.OneDimensionalAccess;
import de.caff.generics.mda.OneDimensionalReadAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;

public class OneDimensionalArray<T>
extends OneDimensionalReadAccess.Base<T>
implements OneDimensionalAccess<T> {
    @NotNull
    private final List<T> elements;

    public OneDimensionalArray(@NotNull Collection<T> collection) {
        this.elements = new ArrayList<T>(collection);
    }

    public OneDimensionalArray(@NotNull Indexable<T> indexable) {
        this.elements = Types.map(new ArrayList(indexable.size()), indexable, object -> object);
    }

    public OneDimensionalArray(int n2) {
        this(n2, n -> null);
    }

    public OneDimensionalArray(int n, @NotNull IntFunction<? extends T> intFunction) {
        this.elements = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            this.elements.add(intFunction.apply(i));
        }
    }

    @SafeVarargs
    public OneDimensionalArray(T ... TArray) {
        this((Collection<T>)Types.asList(TArray));
    }

    public OneDimensionalArray(@NotNull Iterable<T> iterable) {
        ArrayList<T> arrayList = Types.map(new ArrayList(), iterable, object -> object);
        arrayList.trimToSize();
        this.elements = arrayList;
    }

    @Override
    @NotNull
    public OneDimensionalAccess<T> copy() {
        return new OneDimensionalArray<T>(this);
    }

    @Override
    public void set(int n, T t) {
        this.elements.set(n, t);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public T get(int n) {
        return this.elements.get(n);
    }
}

