/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.MutableIndexable;
import de.caff.generics.mda.MultiDimensionalAccess;
import de.caff.generics.mda.OneDimensionalArray;
import de.caff.generics.mda.OneDimensionalReadAccess;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;

public interface OneDimensionalAccess<T>
extends MutableIndexable<T>,
MultiDimensionalAccess<T>,
OneDimensionalReadAccess<T> {
    public static final OneDimensionalAccess<?> EMPTY = new OneDimensionalAccess<Object>(){

        @Override
        public void set(int n, Object object) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Object get(int n) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    @Override
    @NotNull
    default public OneDimensionalAccess<T> copy() {
        return new OneDimensionalArray(this);
    }

    default public void setElementAt(T t, int n) {
        this.set(n, t);
    }

    @Override
    default public void setElement(T t, int ... nArray) {
        if (nArray.length != 1) {
            throw new IllegalArgumentException("Invalid number of indexes for 1-dimensional array: " + nArray.length);
        }
        this.set(nArray[0], t);
    }

    @Override
    default public void changeAll(@NotNull BiFunction<? super T, int[], ? extends T> biFunction) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, biFunction.apply(this.get(i), new int[]{i}));
        }
    }

    @Override
    default public void changeAll(@NotNull Function<? super T, ? extends T> function) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, function.apply(this.get(i)));
        }
    }

    default public void fillByIndex(@NotNull IntFunction<? extends T> intFunction) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setElementAt(intFunction.apply(i), i);
        }
    }

    @NotNull
    public static <E> OneDimensionalAccess<E> empty() {
        return EMPTY;
    }
}

