/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.Indexable;
import de.caff.generics.mda.MultiDimensional;
import de.caff.generics.mda.PartlyFixedMultiIndexLinearizer;

public interface MultiIndexLinearizer
extends MultiDimensional {
    public static final int OPEN = Integer.MIN_VALUE;

    public int toLinear(int ... var1);

    default public MultiIndexLinearizer sub(int ... nArray) {
        for (int n : nArray) {
            if (n < 0) continue;
            return new PartlyFixedMultiIndexLinearizer(this, nArray);
        }
        return this;
    }

    @NotNull
    default public Sequencer getHighFastSequencer() {
        return new BasicSequencer(this){

            @Override
            @NotNull
            protected int[] get(int n, @NotNull int[] nArray) {
                int[] nArray2 = new int[nArray.length];
                for (int i = nArray2.length - 1; i >= 0; --i) {
                    int n2 = nArray[i];
                    nArray2[i] = n % n2;
                    n /= n2;
                }
                return nArray2;
            }
        };
    }

    @NotNull
    default public Sequencer getLowFastSequencer() {
        return new BasicSequencer(this){

            @Override
            @NotNull
            protected int[] get(int n, @NotNull int[] nArray) {
                int[] nArray2 = new int[nArray.length];
                for (int i = 0; i < nArray2.length; ++i) {
                    int n2 = nArray[i];
                    nArray2[i] = n % n2;
                    n /= n2;
                }
                return nArray2;
            }
        };
    }

    public static void checkIndexes(int[] nArray, int ... nArray2) {
        if (nArray2.length != nArray.length) {
            throw new IllegalArgumentException(String.format("Incorrect number of indexes for an array with %d dimensions: %d!", nArray.length, nArray2.length));
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            MultiIndexLinearizer.checkIndex(i, nArray[i], nArray2[i]);
        }
    }

    public static void checkIndex(int n, int n2, int n3) {
        if (n3 < 0 || n3 >= n2) {
            throw new IndexOutOfBoundsException(String.format("Index #%d is out of bounds (size is %d): %d!", n, n3, n2));
        }
    }

    public static abstract class BasicSequencer
    implements Sequencer {
        @NotNull
        private final MultiIndexLinearizer indexLinearizer;
        @NotNull
        private final int[] sizes;

        public BasicSequencer(@NotNull MultiIndexLinearizer multiIndexLinearizer) {
            this.indexLinearizer = multiIndexLinearizer;
            this.sizes = multiIndexLinearizer.getSizes();
        }

        @Override
        public int getNumDimensions() {
            return this.indexLinearizer.getNumDimensions();
        }

        @Override
        public int getSize(int n) {
            return this.indexLinearizer.getSize(n);
        }

        @Override
        public long getNumElements() {
            return this.indexLinearizer.getNumElements();
        }

        @Override
        @NotNull
        public int[] getSizes() {
            return (int[])this.sizes.clone();
        }

        @Override
        public int size() {
            return (int)this.getNumElements();
        }

        @Override
        @NotNull
        public int[] get(int n) {
            int n2 = this.size();
            if (n < 0 || n >= n2) {
                throw new IndexOutOfBoundsException(String.format("Index is out of bounds (0 to %d): %d!", n2, n));
            }
            return this.get(n, this.sizes);
        }

        @NotNull
        protected abstract int[] get(int var1, @NotNull int[] var2);
    }

    public static interface Sequencer
    extends Indexable<int[]>,
    MultiDimensional {
    }
}

