/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.function.Function1;
import de.caff.generics.function.ShortOperator1;
import de.caff.generics.mda.AbstractBasicMultiDimensionalArray;
import de.caff.generics.mda.MappingMultiIndexLinearizer;
import de.caff.generics.mda.MultiIndexLinearizer;
import java.util.Arrays;
import java.util.function.Function;

public class MultiDimensionalShortArray
extends AbstractBasicMultiDimensionalArray<Short> {
    @NotNull
    private final short[] array;

    public MultiDimensionalShortArray(int ... nArray) {
        super(nArray);
        this.array = new short[(int)this.getNumElements()];
    }

    public MultiDimensionalShortArray(@NotNull MultiDimensionalShortArray multiDimensionalShortArray, @NotNull Function1<int[], int[]> function1, int ... nArray) {
        this(multiDimensionalShortArray, new MappingMultiIndexLinearizer(multiDimensionalShortArray.getIndexLinearizer(), function1, nArray));
    }

    private MultiDimensionalShortArray(@NotNull MultiDimensionalShortArray multiDimensionalShortArray, @NotNull MultiIndexLinearizer multiIndexLinearizer) {
        super(multiIndexLinearizer);
        this.array = multiDimensionalShortArray.array;
    }

    @Override
    @NotNull
    public Short getElement(int ... nArray) {
        return this.getValue(nArray);
    }

    @Override
    public void setElement(@NotNull Short s, int ... nArray) {
        this.setValue(s, nArray);
    }

    @Override
    @NotNull
    public Short change(@NotNull Function<? super Short, ? extends Short> function, int ... nArray) {
        return this.changeValue(function::apply, nArray);
    }

    public short getValue(int ... nArray) {
        return this.array[this.toLinear(nArray)];
    }

    public void setValue(short s, int ... nArray) {
        this.array[this.toLinear((int[])nArray)] = s;
    }

    public short changeValue(@NotNull ShortOperator1 shortOperator1, int ... nArray) {
        short s;
        int n = this.toLinear(nArray);
        this.array[n] = s = shortOperator1.applyAsShort(this.array[n]);
        return s;
    }

    public void setValuesFrom(short ... sArray) {
        if (sArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), sArray.length));
        }
        System.arraycopy(sArray, 0, this.array, 0, this.array.length);
    }

    public void setValuesFrom(@NotNull MultiIndexLinearizer.Sequencer sequencer, short ... sArray) {
        if (sArray.length < this.array.length) {
            throw new IllegalArgumentException(String.format("Need at least %d elements for setting, but got %d!", this.getNumElements(), sArray.length));
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            this.array[this.toLinear((int[])((int[])sequencer.get((int)i)))] = sArray[i];
        }
    }

    @NotNull
    public MultiDimensionalShortArray sub(int ... nArray) {
        return new MultiDimensionalShortArray(this, this.indexLinearizer.sub(nArray));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MultiDimensionalShortArray multiDimensionalShortArray = (MultiDimensionalShortArray)object;
        if (!Arrays.equals(this.getSizes(), multiDimensionalShortArray.getSizes())) {
            return false;
        }
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            if (this.getValue(nArray) == multiDimensionalShortArray.getElement(nArray).shortValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.getSizes(), this.toList(this.indexLinearizer.getHighFastSequencer())});
    }

    @NotNull
    public MultiDimensionalShortArray getCopy() {
        MultiDimensionalShortArray multiDimensionalShortArray = new MultiDimensionalShortArray(this.getSizes());
        for (int[] nArray : this.indexLinearizer.getHighFastSequencer()) {
            multiDimensionalShortArray.setValue(this.getValue(nArray), nArray);
        }
        return multiDimensionalShortArray;
    }
}

