/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics.mda;

import de.caff.annotation.NotNull;
import de.caff.generics.Empty;
import de.caff.generics.Types;
import de.caff.generics.function.Procedure1;
import de.caff.generics.function.Procedure2;
import de.caff.generics.mda.MultiDimensional;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface MultiDimensionalReadAccess<T>
extends MultiDimensional {
    public static final MultiDimensionalReadAccess<?> EMPTY0 = new MultiDimensionalReadAccess<Object>(){

        @Override
        public Object getElement(int ... nArray) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getNumDimensions() {
            return 0;
        }

        @Override
        public int getSize(int n) {
            throw new IllegalArgumentException("No dimension " + n);
        }

        @Override
        @NotNull
        public int[] getSizes() {
            return Empty.INT_ARRAY;
        }

        @Override
        public long getNumElements() {
            return 0L;
        }

        @Override
        public void visitAll(@NotNull Procedure2<? super Object, int[]> procedure2) {
        }

        @Override
        public void visitAll(@NotNull Procedure1<? super Object> procedure1) {
        }

        @Override
        @NotNull
        public Iterable<Object> linearized() {
            return Types.emptyIterable();
        }
    };
    public static final MultiDimensionalReadAccess<?> EMPTY1 = new MultiDimensionalReadAccess<Object>(){

        @Override
        public Object getElement(int ... nArray) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getNumDimensions() {
            return 1;
        }

        @Override
        public int getSize(int n) {
            switch (n) {
                case 0: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("No dimension " + n);
        }

        @Override
        @NotNull
        public int[] getSizes() {
            return new int[1];
        }

        @Override
        public long getNumElements() {
            return 0L;
        }

        @Override
        public void visitAll(@NotNull Procedure2<? super Object, int[]> procedure2) {
        }

        @Override
        public void visitAll(@NotNull Procedure1<? super Object> procedure1) {
        }

        @Override
        @NotNull
        public Iterable<Object> linearized() {
            return Types.emptyIterable();
        }
    };
    public static final MultiDimensionalReadAccess<?> EMPTY2 = new MultiDimensionalReadAccess<Object>(){

        @Override
        public Object getElement(int ... nArray) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getNumDimensions() {
            return 2;
        }

        @Override
        public int getSize(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("No dimension " + n);
        }

        @Override
        @NotNull
        public int[] getSizes() {
            return new int[2];
        }

        @Override
        public long getNumElements() {
            return 0L;
        }

        @Override
        public void visitAll(@NotNull Procedure2<? super Object, int[]> procedure2) {
        }

        @Override
        public void visitAll(@NotNull Procedure1<? super Object> procedure1) {
        }

        @Override
        @NotNull
        public Iterable<Object> linearized() {
            return Types.emptyIterable();
        }
    };
    public static final MultiDimensionalReadAccess<?> EMPTY3 = new MultiDimensionalReadAccess<Object>(){

        @Override
        public Object getElement(int ... nArray) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getNumDimensions() {
            return 3;
        }

        @Override
        public int getSize(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("No dimension " + n);
        }

        @Override
        @NotNull
        public int[] getSizes() {
            return new int[3];
        }

        @Override
        public long getNumElements() {
            return 0L;
        }

        @Override
        public void visitAll(@NotNull Procedure2<? super Object, int[]> procedure2) {
        }

        @Override
        public void visitAll(@NotNull Procedure1<? super Object> procedure1) {
        }

        @Override
        @NotNull
        public Iterable<Object> linearized() {
            return Types.emptyIterable();
        }
    };
    public static final MultiDimensionalReadAccess<?> EMPTY4 = new MultiDimensionalReadAccess<Object>(){

        @Override
        public Object getElement(int ... nArray) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getNumDimensions() {
            return 4;
        }

        @Override
        public int getSize(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("No dimension " + n);
        }

        @Override
        @NotNull
        public int[] getSizes() {
            return new int[4];
        }

        @Override
        public long getNumElements() {
            return 0L;
        }

        @Override
        public void visitAll(@NotNull Procedure2<? super Object, int[]> procedure2) {
        }

        @Override
        public void visitAll(@NotNull Procedure1<? super Object> procedure1) {
        }

        @Override
        @NotNull
        public Iterable<Object> linearized() {
            return Types.emptyIterable();
        }
    };
    public static final MultiDimensionalReadAccess<?> EMPTY5 = new MultiDimensionalReadAccess<Object>(){

        @Override
        public Object getElement(int ... nArray) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getNumDimensions() {
            return 5;
        }

        @Override
        public int getSize(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("No dimension " + n);
        }

        @Override
        @NotNull
        public int[] getSizes() {
            return new int[5];
        }

        @Override
        public long getNumElements() {
            return 0L;
        }

        @Override
        public void visitAll(@NotNull Procedure2<? super Object, int[]> procedure2) {
        }

        @Override
        public void visitAll(@NotNull Procedure1<? super Object> procedure1) {
        }

        @Override
        @NotNull
        public Iterable<Object> linearized() {
            return Types.emptyIterable();
        }
    };
    public static final MultiDimensionalReadAccess<?> EMPTY6 = new MultiDimensionalReadAccess<Object>(){

        @Override
        public Object getElement(int ... nArray) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getNumDimensions() {
            return 6;
        }

        @Override
        public int getSize(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("No dimension " + n);
        }

        @Override
        @NotNull
        public int[] getSizes() {
            return new int[6];
        }

        @Override
        public long getNumElements() {
            return 0L;
        }

        @Override
        public void visitAll(@NotNull Procedure2<? super Object, int[]> procedure2) {
        }

        @Override
        public void visitAll(@NotNull Procedure1<? super Object> procedure1) {
        }

        @Override
        @NotNull
        public Iterable<Object> linearized() {
            return Types.emptyIterable();
        }
    };
    public static final MultiDimensionalReadAccess<?> EMPTY7 = new MultiDimensionalReadAccess<Object>(){

        @Override
        public Object getElement(int ... nArray) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getNumDimensions() {
            return 7;
        }

        @Override
        public int getSize(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("No dimension " + n);
        }

        @Override
        @NotNull
        public int[] getSizes() {
            return new int[7];
        }

        @Override
        public long getNumElements() {
            return 0L;
        }

        @Override
        public void visitAll(@NotNull Procedure2<? super Object, int[]> procedure2) {
        }

        @Override
        public void visitAll(@NotNull Procedure1<? super Object> procedure1) {
        }

        @Override
        @NotNull
        public Iterable<Object> linearized() {
            return Types.emptyIterable();
        }
    };

    public T getElement(int ... var1);

    default public void visitAll(@NotNull Procedure2<? super T, int[]> procedure2) {
        int n;
        int[] nArray = this.getSizes();
        int n2 = nArray.length;
        if (n2 == 0) {
            return;
        }
        int[] nArray2 = new int[n2];
        int n3 = n = n2 - 1;
        block0: while (n3 >= 0) {
            procedure2.apply(this.getElement(nArray2), (int[])nArray2.clone());
            for (n3 = n; n3 >= 0; --n3) {
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + 1;
                if (nArray2[n4] < nArray[n3]) continue block0;
                nArray2[n3] = 0;
            }
        }
    }

    default public void visitAll(@NotNull Procedure1<? super T> procedure1) {
        int n;
        int[] nArray = this.getSizes();
        int n2 = nArray.length;
        if (n2 == 0) {
            return;
        }
        int[] nArray2 = new int[n2];
        int n3 = n = n2 - 1;
        block0: while (n3 >= 0) {
            procedure1.apply(this.getElement(nArray2));
            for (n3 = n; n3 >= 0; --n3) {
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + 1;
                if (nArray2[n4] < nArray[n3]) continue block0;
                nArray2[n3] = 0;
            }
        }
    }

    @NotNull
    default public Iterable<T> linearized() {
        final int[] nArray = this.getSizes();
        final int n = nArray.length;
        if (n == 0) {
            return Types.emptyIterable();
        }
        final int n2 = n - 1;
        return () -> new Iterator<T>(){
            private final int[] run;
            private int carry;
            {
                this.run = new int[n];
                this.carry = n2;
            }

            @Override
            public boolean hasNext() {
                return this.carry >= 0;
            }

            @Override
            public T next() {
                if (this.carry < 0) {
                    throw new NoSuchElementException();
                }
                Object t = MultiDimensionalReadAccess.this.getElement(this.run);
                this.carry = n2;
                while (this.carry >= 0) {
                    int n3 = this.carry;
                    this.run[n3] = this.run[n3] + 1;
                    if (this.run[n3] < nArray[this.carry]) break;
                    this.run[this.carry] = 0;
                    --this.carry;
                }
                return t;
            }
        };
    }

    @NotNull
    public static <E> MultiDimensionalReadAccess<E> empty(final int n) {
        if (n < 0) {
            throw new IllegalArgumentException("numDimensions has to be non-negative, but is " + n);
        }
        switch (n) {
            case 0: {
                return EMPTY0;
            }
            case 1: {
                return EMPTY1;
            }
            case 2: {
                return EMPTY2;
            }
            case 3: {
                return EMPTY3;
            }
            case 4: {
                return EMPTY4;
            }
            case 5: {
                return EMPTY5;
            }
            case 6: {
                return EMPTY6;
            }
            case 7: {
                return EMPTY7;
            }
        }
        return new MultiDimensionalReadAccess<E>(){

            @Override
            public E getElement(int ... nArray) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int getNumDimensions() {
                return n;
            }

            @Override
            public int getSize(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IllegalArgumentException("No dimension " + n2);
                }
                return 0;
            }

            @Override
            @NotNull
            public int[] getSizes() {
                return new int[n];
            }

            @Override
            public long getNumElements() {
                return 0L;
            }

            @Override
            public void visitAll(@NotNull Procedure2<? super E, int[]> procedure2) {
            }

            @Override
            public void visitAll(@NotNull Procedure1<? super E> procedure1) {
            }

            @Override
            @NotNull
            public Iterable<E> linearized() {
                return Types.emptyIterable();
            }
        };
    }
}

